/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.abraxator.moresnifferflowers.client.gui.slot.HardenedMouthSlot;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.networking.toClient.SyncMouthSlotsPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class HardenedMouthCapability {
    public static int SLOT_COUNT = 2;
    public NonNullList<ItemStack> mouthSlots;
    public int cooldown;
    public static final Codec<List<ItemStack>> ITEMSTACK_LIST_CODEC = ItemStack.CODEC.listOf().validate(list -> list.size() != 2 ? DataResult.error(() -> "Expected 2 items, got " + list.size()) : DataResult.success(list.stream().map(stack -> stack.isEmpty() ? ModItems.PLACEHOLDER.toStack() : stack).toList()));
    public static final Codec<ItemStack> SAFE_ITEMSTACK_CODEC = ItemStack.CODEC.xmap(stack -> stack.is(ModItems.PLACEHOLDER) ? ItemStack.EMPTY : stack, stack -> stack.isEmpty() ? ModItems.PLACEHOLDER.toStack() : stack);
    public static final Codec<HardenedMouthCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NonNullList.codecOf(SAFE_ITEMSTACK_CODEC).fieldOf("slots").forGetter(cap -> cap.mouthSlots), (App)Codec.INT.fieldOf("cooldown").forGetter(cap -> cap.cooldown)).apply((Applicative)instance, HardenedMouthCapability::new));

    public HardenedMouthCapability(NonNullList<ItemStack> list, int cooldown) {
        this.cooldown = cooldown;
        this.mouthSlots = NonNullList.withSize((int)SLOT_COUNT, (Object)ItemStack.EMPTY);
        for (int i = 0; i < SLOT_COUNT; ++i) {
            this.mouthSlots.set(i, (Object)((ItemStack)list.get(i)));
        }
    }

    public NonNullList<ItemStack> getMouthSlotItems() {
        return this.mouthSlots;
    }

    public void setAllItems(NonNullList<ItemStack> itemStacks) {
        for (int i = 0; i < itemStacks.size(); ++i) {
            this.setItem(i, (ItemStack)itemStacks.get(i));
        }
    }

    public void setItem(int index, ItemStack stack) {
        this.mouthSlots.set(index, (Object)stack);
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.mouthSlots.get(index);
    }

    public void clear() {
        this.mouthSlots.clear();
    }

    public void sync(Player player) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncMouthSlotsPacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void onEffectEnd(Player player) {
        this.getMouthSlotItems().forEach(itemStack -> {
            if (HardenedMouthSlot.moveToPlayerInventory((AbstractContainerMenu)player.inventoryMenu, itemStack)) {
                return;
            }
            if (itemStack.isEmpty()) {
                return;
            }
            player.drop(itemStack, true);
        });
        this.clear();
        this.sync(player);
    }

    public void tick(Player player) {
        if (player.level().isClientSide || !player.hasEffect(ModEffects.HARDENED_MOUTH)) {
            return;
        }
        ItemStack input = this.getItem(0);
        ItemStack output = this.getItem(1);
        if (this.getSmeltingResult(player.level(), input).isEmpty() || !this.getSmeltingResult(player.level(), input).get().is(output.getItem()) && !output.isEmpty()) {
            this.cooldown = this.getMaxCooldown(player);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            this.sync(player);
            return;
        }
        this.getSmeltingResult(player.level(), input).ifPresentOrElse(result -> {
            if (output.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result) && output.getCount() < output.getMaxStackSize()) {
                input.shrink(1);
                if (output.isEmpty()) {
                    this.setItem(1, result.copy());
                } else {
                    output.grow(1);
                    this.setItem(1, output);
                }
                this.setItem(0, input);
                this.cooldown = this.getMaxCooldown(player);
            }
        }, () -> {
            this.cooldown = this.getMaxCooldown(player);
        });
        this.sync(player);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getMaxCooldown(Player player) {
        int amplifier = 0;
        if (player.hasEffect(ModEffects.HARDENED_MOUTH)) {
            amplifier = player.getEffect(ModEffects.HARDENED_MOUTH).getAmplifier();
        }
        return Math.max(1, 80 - amplifier * 10);
    }

    public Optional<ItemStack> getSmeltingResult(Level level, ItemStack input) {
        return level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(input), level).map(recipe -> ((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()));
    }

    public boolean isEmpty() {
        return this.getItem(0).isEmpty() && this.getItem(1).isEmpty();
    }
}

