/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.screen;

import java.util.Optional;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.client.gui.menu.RebrewingStandMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RebrewingStandScreen
extends AbstractContainerScreen<RebrewingStandMenu> {
    public static final ResourceLocation TEXTURE = MoreSnifferFlowers.loc("textures/gui/container/rebrewing_stand.png");
    private static final int[] BUBBLELENGTHS = new int[]{0, 5, 8, 12, 17, 22, 27};

    public RebrewingStandScreen(RebrewingStandMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderOnboardingTooltips(guiGraphics, mouseX, mouseY, x, y);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int fuel = ((RebrewingStandMenu)this.menu).getFuel();
        int progress = ((RebrewingStandMenu)this.menu).getBrewingTicks();
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((RebrewingStandMenu)this.menu).getCost() <= 16) {
            String cost = String.valueOf(((RebrewingStandMenu)this.menu).getCost());
            int color = Minecraft.getInstance().getResourceManager().listPacks().anyMatch(packResources -> packResources.packId().equals("more_sniffer_flowers_boring")) ? 0xC6C6C6 : 9649229;
            int colorOutline = Minecraft.getInstance().getResourceManager().listPacks().anyMatch(packResources -> packResources.packId().equals("more_sniffer_flowers_boring")) ? 0x373737 : 6169167;
            this.drawCost(guiGraphics, cost, x, y, colorOutline, -1, 0);
            this.drawCost(guiGraphics, cost, x, y, colorOutline, 1, 0);
            this.drawCost(guiGraphics, cost, x, y, colorOutline, 0, -1);
            this.drawCost(guiGraphics, cost, x, y, colorOutline, 0, 1);
            this.drawCost(guiGraphics, cost, x, y, color, 0, 0);
        } else {
            guiGraphics.blit(TEXTURE, x + 30, y + 45, 197, 0, 19, 11);
        }
        if (fuel > 0) {
            int renderFuel = -(fuel * 2);
            guiGraphics.blit(TEXTURE, x + 57, y + 42, 209, 40, renderFuel, -11);
        }
        if (progress > 0) {
            int arrowScale = (int)Mth.lerp((float)((float)progress / 100.0f), (float)0.0f, (float)27.0f);
            guiGraphics.blit(TEXTURE, x + 124, y + 18, 177, 1, 8, arrowScale);
            int bubbleFactor = BUBBLELENGTHS[progress / 2 % 7];
            guiGraphics.blit(TEXTURE, x + 58, y + 37 - bubbleFactor, 186, 28 - bubbleFactor, 11, bubbleFactor);
        }
    }

    public void renderOnboardingTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        Optional<Component> optional = Optional.empty();
        if (RebrewingStandScreen.isMouseOver(mouseX, mouseY, x + 24, y + 31, 33, 11)) {
            guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)Component.literal((String)(((RebrewingStandMenu)this.menu).getFuel() + "/16")), 115), mouseX, mouseY);
        }
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            switch (this.hoveredSlot.index) {
                case 0: {
                    optional = Optional.of(this.component("fuel", "Add Cropressed Nether Wart"));
                    break;
                }
                case 1: {
                    optional = Optional.of(this.component("og_potion", "Add Extracted Potion"));
                    break;
                }
                case 2: {
                    optional = Optional.of(this.component("ingredient", "Add Ingredient"));
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    optional = Optional.of(this.component("potion", "Add Water Bottle"));
                    break;
                }
                default: {
                    return;
                }
            }
        }
        optional.ifPresent(component -> guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)component, 115), mouseX, mouseY));
    }

    private void drawCost(GuiGraphics guiGraphics, String cost, int x, int y, int color, int xOffset, int yOffset) {
        this.font.drawInBatch(cost, (float)(x + 40 - this.font.width(cost) / 2 + xOffset), (float)(y + 46 + yOffset), color, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0, this.font.isBidirectional());
    }

    private Component component(String id, String fallback) {
        return Component.translatableWithFallback((String)("tooltip.moresnifferflowers.rebrewing_stand." + id), (String)fallback);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX <= (double)(x + sizeX) && mouseY >= (double)y && mouseY <= (double)(y + sizeY);
    }
}

