/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.particle;

import net.abraxator.moresnifferflowers.init.ModParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class BondripiaParticle
extends TextureSheetParticle {
    protected BondripiaParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class AcidripiaLandProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public AcidripiaLandProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            BondripiaSplashParticle splashParticle = new BondripiaSplashParticle(level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            splashParticle.pickSprite(this.spriteSet);
            return splashParticle;
        }
    }

    public static class AcidripiaFallProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public AcidripiaFallProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FallAndLandParticle bondripiaParticle = new FallAndLandParticle(level, pX, pY, pZ, (ParticleOptions)ModParticles.ACIDRIPIA_LAND.get());
            bondripiaParticle.pickSprite(this.spriteSet);
            ((BondripiaParticle)bondripiaParticle).lifetime = (int)(16.0 / (Math.random() * 0.4 + 0.2));
            ((BondripiaParticle)bondripiaParticle).gravity = 0.007f;
            return bondripiaParticle;
        }
    }

    public static class AcidripiaDripProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public AcidripiaDripProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            DripHangParticle bondripiaParticle = new DripHangParticle(level, pX, pY, pZ, (ParticleOptions)ModParticles.ACIDRIPIA_FALL.get());
            bondripiaParticle.pickSprite(this.spriteSet);
            ((BondripiaParticle)bondripiaParticle).lifetime = (int)(16.0 / (Math.random() * 0.4 + 0.2));
            ((BondripiaParticle)bondripiaParticle).gravity = 0.007f;
            return bondripiaParticle;
        }
    }

    public static class BondripiaLandProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public BondripiaLandProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            BondripiaSplashParticle splashParticle = new BondripiaSplashParticle(level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            splashParticle.pickSprite(this.spriteSet);
            return splashParticle;
        }
    }

    public static class BondripiaFallProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public BondripiaFallProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FallAndLandParticle bondripiaParticle = new FallAndLandParticle(level, pX, pY, pZ, (ParticleOptions)ModParticles.BONDRIPIA_LAND.get());
            bondripiaParticle.pickSprite(this.spriteSet);
            ((BondripiaParticle)bondripiaParticle).lifetime = (int)(16.0 / (Math.random() * 0.4 + 0.2));
            ((BondripiaParticle)bondripiaParticle).gravity = 0.007f;
            return bondripiaParticle;
        }
    }

    public static class BondripiaDripProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public BondripiaDripProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            DripHangParticle bondripiaParticle = new DripHangParticle(level, pX, pY, pZ, (ParticleOptions)ModParticles.BONDRIPIA_FALL.get());
            bondripiaParticle.pickSprite(this.spriteSet);
            ((BondripiaParticle)bondripiaParticle).lifetime = (int)(16.0 / (Math.random() * 0.4 + 0.2));
            ((BondripiaParticle)bondripiaParticle).gravity = 0.007f;
            return bondripiaParticle;
        }
    }

    static class BondripiaSplashParticle
    extends WaterDropParticle {
        BondripiaSplashParticle(ClientLevel level, double x, double y, double z, double xS, double yS, double zS) {
            super(level, x, y, z);
            this.gravity = 0.01f;
            this.yd = 0.05;
        }
    }

    static class FallAndLandParticle
    extends FallingParticle {
        protected final ParticleOptions landParticle;

        FallAndLandParticle(ClientLevel level, double x, double y, double z, ParticleOptions landParticle) {
            super(level, x, y, z);
            this.landParticle = landParticle;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.landParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
        }
    }

    static class FallingParticle
    extends BondripiaParticle {
        FallingParticle(ClientLevel level, double x, double y, double z) {
            this(level, x, y, z, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        FallingParticle(ClientLevel level, double x, double y, double z, int lifetime) {
            super(level, x, y, z);
            this.lifetime = lifetime;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
            }
        }
    }

    static class DripHangParticle
    extends BondripiaParticle {
        private final ParticleOptions fallingParticle;

        DripHangParticle(ClientLevel level, double x, double y, double z, ParticleOptions fallingParticle) {
            super(level, x, y, z);
            this.fallingParticle = fallingParticle;
            this.gravity *= 0.02f;
            this.lifetime = 40;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.lifetime-- <= 0) {
                this.remove();
                this.level.addParticle(this.fallingParticle, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
    }
}

