/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.GiantCropBlockEntity;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.pipeline.VertexConsumerWrapper;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.client.IMultiblockRenderHelper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import org.joml.Quaternionf;

public class GiantCropBlockEntityRenderer<T extends GiantCropBlockEntity>
implements BlockEntityRenderer<T>,
IMultiblockRenderHelper {
    private final Map<Block, ModelPart> modelPartMap = new HashMap<Block, ModelPart>();

    public GiantCropBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart carrot = context.bakeLayer(ModModelLayerLocations.GIANT_CARROT).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_CARROT.get(), carrot);
        ModelPart potato = context.bakeLayer(ModModelLayerLocations.GIANT_POTATO).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_POTATO.get(), potato);
        ModelPart netherwart = context.bakeLayer(ModModelLayerLocations.GIANT_NETHERWART).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_NETHERWART.get(), netherwart);
        ModelPart beetroot = context.bakeLayer(ModModelLayerLocations.GIANT_BEETROOT).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_BEETROOT.get(), beetroot);
        ModelPart wheat = context.bakeLayer(ModModelLayerLocations.GIANT_WHEAT).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_WHEAT.get(), wheat);
        ModelPart onion = context.bakeLayer(ModModelLayerLocations.GIANT_ONION).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_ONION.get(), onion);
        ModelPart tomato = context.bakeLayer(ModModelLayerLocations.GIANT_TOMATO).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_TOMATO.get(), tomato);
        ModelPart cabbage = context.bakeLayer(ModModelLayerLocations.GIANT_CABBAGE).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_CABBAGE.get(), cabbage);
        ModelPart rice = context.bakeLayer(ModModelLayerLocations.GIANT_RICE).getChild("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_RICE.get(), rice);
    }

    public void render(GiantCropBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.getBlockState();
        String path = blockState.getBlock().getDescriptionId().replace("block.moresnifferflowers.", "");
        Material TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/" + path));
        PreviewMode previewMode = blockEntity.previewMode;
        Function renderType = this.getRenderTypeFunction(previewMode);
        Object vertexConsumer = TEXTURE.buffer(buffer, renderType);
        double growProgress = previewMode.equals((Object)PreviewMode.PLACED) ? blockEntity.growProgress : 1.0;
        float coolPartialTick = growProgress < 1.0 && blockState.is(ModTags.ModBlockTags.GIANT_CROPS) && IMultiBlock.isCenter((BlockState)blockState) ? partialTick : 0.0f;
        float coolGrowProgress = (float)this.level().getGameTime() - blockEntity.staticGameTime;
        if (growProgress > 0.0 && blockState.is(ModTags.ModBlockTags.GIANT_CROPS) && IMultiBlock.isCenter((BlockState)blockState)) {
            float yCord = 0.5f;
            float yScale = 1.0f;
            if (!previewMode.equals((Object)PreviewMode.PLACED)) {
                yCord += 1.0f;
            }
            if (growProgress < 1.0) {
                yCord = (coolGrowProgress + coolPartialTick) / 4.0f - 2.0f;
                yScale = Mth.lerp((float)((coolGrowProgress + coolPartialTick) / 10.0f), (float)0.0f, (float)1.0f);
            }
            poseStack.pushPose();
            poseStack.translate(0.5, (double)yCord, 0.5);
            poseStack.scale(1.0f, yScale, 1.0f);
            poseStack.mulPose(new Quaternionf().rotateX((float)Math.PI));
            if (blockState.is(ModTags.ModBlockTags.NO_SHADING)) {
                vertexConsumer = new VertexConsumerWrapper(this, (VertexConsumer)vertexConsumer){

                    public VertexConsumer setNormal(float x, float y, float z) {
                        return super.setNormal(1.0f, 1.0f, 1.0f);
                    }
                };
            }
            this.render(this.modelPartMap.get(blockState.getBlock()), poseStack, (VertexConsumer)vertexConsumer, packedLight, packedOverlay, blockEntity.previewMode);
            poseStack.popPose();
        }
    }

    public int getViewDistance() {
        return 256;
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        return new AABB(((GiantCropBlockEntity)blockEntity).center).inflate(1.1);
    }
}

