/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.blocks.ColorableVivicusBlock;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VivicusSignRenderer
extends SignRenderer {
    public VivicusSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void renderSignWithText(SignBlockEntity pSignEntity, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, BlockState state, SignBlock pSignBlock, WoodType pWoodType, Model pModel) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.75f * this.getSignModelRenderScale(), 0.5f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(-pSignBlock.getYRotationDegrees(state)));
        if (!(state.getBlock() instanceof StandingSignBlock)) {
            pPoseStack.translate(0.0f, -0.3125f, -0.4375f);
        }
        this.renderVivicusSign(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pWoodType, pModel, state);
        this.renderSignText(pSignEntity.getBlockPos(), pSignEntity.getFrontText(), pPoseStack, pBuffer, pPackedLight, pSignEntity.getTextLineHeight(), pSignEntity.getMaxTextLineWidth(), true);
        this.renderSignText(pSignEntity.getBlockPos(), pSignEntity.getBackText(), pPoseStack, pBuffer, pPackedLight, pSignEntity.getTextLineHeight(), pSignEntity.getMaxTextLineWidth(), false);
        pPoseStack.popPose();
    }

    private void renderVivicusSign(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, WoodType pWoodType, Model pModel, BlockState state) {
        pPoseStack.pushPose();
        float f = this.getSignModelRenderScale();
        pPoseStack.scale(f, -f, -f);
        Material material = Sheets.getSignMaterial((WoodType)pWoodType);
        VertexConsumer vertexconsumer = material.buffer(pBuffer, arg_0 -> ((Model)pModel).renderType(arg_0));
        int color = -1;
        Block block = state.getBlock();
        if (block instanceof ColorableVivicusBlock) {
            ColorableVivicusBlock colorableVivicusBlock = (ColorableVivicusBlock)block;
            DyeColor dyeColor = (DyeColor)state.getValue(ModStateProperties.COLOR);
            color = colorableVivicusBlock.colorValues().get(dyeColor);
            vertexconsumer.setColor(color);
        }
        this.renderSignModel(pPoseStack, pPackedLight, pPackedOverlay, pModel, vertexconsumer, color);
        pPoseStack.popPose();
    }

    void renderSignModel(PoseStack pPoseStack, int pPackedLight, int pPackedOverlay, Model pModel, VertexConsumer pVertexConsumer, int color) {
        SignRenderer.SignModel signrenderer$signmodel = (SignRenderer.SignModel)pModel;
        signrenderer$signmodel.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, color);
    }
}

