/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abraxator.moresnifferflowers.client.renderer.custom.GhostRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.nikdo53.tinymultiblocklib.client.VertexConsumerWrapper;

public class GhostBlockRenderer
extends GhostRenderer {
    protected BlockState state;
    protected RenderType renderType = RenderType.translucent();
    protected boolean checkSides = true;

    public GhostBlockRenderer(BlockPos pos, int ticksRemaining, BlockState state) {
        super(pos, ticksRemaining);
        this.state = state;
    }

    @Override
    public void render(float partialTick, Frustum frustum, Camera camera, Level level, PoseStack poseStack, MultiBufferSource.BufferSource buffer) {
        Minecraft minecraft = Minecraft.getInstance();
        final GhostBlockRenderer ghostRenderer = this;
        VertexConsumerWrapper tintedConsumer = new VertexConsumerWrapper(this, buffer.getBuffer(this.renderType)){

            public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float[] brightness, float red, float green, float blue, float alpha, int[] lightmap, int packedOverlay, boolean readAlpha) {
                super.putBulkData(pose, quad, brightness, ghostRenderer.red, ghostRenderer.green, ghostRenderer.blue, ghostRenderer.alpha, lightmap, packedOverlay, readAlpha);
            }
        };
        minecraft.getBlockRenderer().renderBatched(this.state, this.pos, (BlockAndTintGetter)level, poseStack, (VertexConsumer)tintedConsumer, this.checkSides, minecraft.level.getRandom());
    }

    public GhostBlockRenderer setCheckSides(boolean checkSides) {
        this.checkSides = checkSides;
        return this;
    }

    public GhostBlockRenderer setRenderType(RenderType renderType) {
        this.renderType = renderType;
        return this;
    }
}

