/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.components.RenderOffsetType;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class GhostRenderer {
    public static List<GhostRenderer> RENDERERS = new ArrayList<GhostRenderer>();
    protected BlockPos pos;
    protected int ticksRemaining;
    protected final int maxTicksRemaining;
    protected RenderOffsetType renderOffsetType = RenderOffsetType.SCALED;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    protected float alpha = 1.0f;
    protected float maxAlpha = 1.0f;
    protected Integer fadeOutTicks = null;

    protected GhostRenderer(BlockPos pos, int ticksRemaining) {
        this.pos = pos;
        this.ticksRemaining = ticksRemaining;
        this.maxTicksRemaining = ticksRemaining;
    }

    public void addToRenderList() {
        this.maxAlpha = this.alpha;
        RENDERERS.add(this);
    }

    public static void renderAll(float partialTick, Frustum frustum, Camera camera, Level level, PoseStack poseStack) {
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        double camX = camera.getPosition().x;
        double camY = camera.getPosition().y;
        double camZ = camera.getPosition().z;
        poseStack.pushPose();
        poseStack.translate(-camX, -camY, -camZ);
        ArrayList<GhostRenderer> renderers = new ArrayList<GhostRenderer>(RENDERERS);
        renderers.forEach(renderer -> renderer.prepareAndRender(partialTick, frustum, camera, level, poseStack, buffer));
        poseStack.popPose();
    }

    public static void tickAll() {
        RENDERERS.removeIf(renderer -> {
            --renderer.ticksRemaining;
            return renderer.ticksRemaining < 0;
        });
    }

    public void prepareAndRender(float partialTick, Frustum frustum, Camera camera, Level level, PoseStack poseStack, MultiBufferSource.BufferSource buffer) {
        poseStack.pushPose();
        poseStack.translate((float)this.pos.getX(), (float)this.pos.getY(), (float)this.pos.getZ());
        this.renderOffsetType.applyTransforms(poseStack);
        if (this.fadeOutTicks != null) {
            this.doFadeOut(partialTick);
        }
        this.render(partialTick, frustum, camera, level, poseStack, buffer);
        buffer.endLastBatch();
        poseStack.popPose();
    }

    private void doFadeOut(float partialTick) {
        if (this.ticksRemaining <= this.fadeOutTicks) {
            float smoothTicks = ((float)this.ticksRemaining - partialTick) / (float)this.fadeOutTicks.intValue();
            if (smoothTicks < 0.0f) {
                smoothTicks = 0.0f;
            }
            this.setARGB(this.red, this.green, this.blue, smoothTicks * this.maxAlpha);
        }
    }

    public abstract void render(float var1, Frustum var2, Camera var3, Level var4, PoseStack var5, MultiBufferSource.BufferSource var6);

    public GhostRenderer setRenderOffsetType(RenderOffsetType renderOffsetType) {
        this.renderOffsetType = renderOffsetType;
        return this;
    }

    public GhostRenderer setARGB(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public GhostRenderer enableFadeOut(int fadeOutTicks) {
        if (fadeOutTicks <= this.ticksRemaining) {
            this.fadeOutTicks = fadeOutTicks;
        } else {
            MoreSnifferFlowers.LOGGER.error(String.valueOf(this) + " fadeOutTicks can't be larger than remaining ticks");
        }
        return this;
    }
}

