/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.entities.boat.ModBoatEntity;
import net.abraxator.moresnifferflowers.entities.boat.ModChestBoatEntity;
import net.abraxator.moresnifferflowers.entities.boat.VivicusBoatEntity;
import net.abraxator.moresnifferflowers.entities.boat.VivicusChestBoatEntity;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class ModBoatRenderer
extends BoatRenderer {
    private final Map<ModBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"moresnifferflowers", (String)ModBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(context, (ModBoatEntity.Type)((Object)type), pChestBoat))));

    public ModBoatRenderer(EntityRendererProvider.Context context, boolean pChestBoat) {
        super(context, pChestBoat);
    }

    public void render(Boat pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pPoseStack.pushPose();
        pPoseStack.translate(0.0f, 0.375f, 0.0f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - pEntityYaw));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = pEntity.getBubbleAngle(pPartialTicks)), (float)0.0f)) {
            pPoseStack.mulPose(new Quaternionf().setAngleAxis(pEntity.getBubbleAngle(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(pEntity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        pPoseStack.scale(-1.0f, -1.0f, 1.0f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        listmodel.setupAnim((Entity)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(listmodel.renderType(resourcelocation));
        listmodel.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, this.boatColor(pEntity));
        if (!pEntity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = pBuffer.getBuffer(RenderType.waterMask());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.waterPatch().render(pPoseStack, vertexconsumer1, pPackedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        pPoseStack.popPose();
    }

    private static String getTextureLocation(ModBoatEntity.Type type, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, ModBoatEntity.Type type, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? ModBoatRenderer.createChestBoatModelName(type) : ModBoatRenderer.createBoatModelName(type);
        ModelPart modelpart = context.bakeLayer(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(ModBoatEntity.Type type) {
        return ModBoatRenderer.createLocation("boat/" + type.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(ModBoatEntity.Type type) {
        return ModBoatRenderer.createLocation("chest_boat/" + type.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"moresnifferflowers", (String)pPath), pModel);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getModVariant());
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getModVariant());
        }
        return null;
    }

    private ModBoatEntity.Type getType(Boat boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return modBoat.getModVariant();
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return modChestBoatEntity.getModVariant();
        }
        return null;
    }

    private int boatColor(Boat boat) {
        if (this.getType(boat).equals((Object)ModBoatEntity.Type.VIVICUS)) {
            if (boat instanceof VivicusBoatEntity) {
                VivicusBoatEntity vivicusBoat = (VivicusBoatEntity)boat;
                return (Integer)vivicusBoat.colorValues().get(vivicusBoat.getColor());
            }
            if (boat instanceof VivicusChestBoatEntity) {
                VivicusChestBoatEntity vivicusChestBoat = (VivicusChestBoatEntity)boat;
                return (Integer)vivicusChestBoat.colorValues().get(vivicusChestBoat.getColor());
            }
        }
        return -1;
    }
}

