/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.compat.jei.corruption;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.compat.jei.corruption.CorruptionRecipe;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class CorruptionCategory
implements IRecipeCategory<CorruptionRecipe> {
    public static final RecipeType<CorruptionRecipe> CORRUPTING = RecipeType.create((String)"moresnifferflowers", (String)"corrupting", CorruptionRecipe.class);
    private final IDrawable icon;
    private final Component localizedName;

    public CorruptionCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableItemStack(((Item)ModItems.CORRUPTED_SLIME_BALL.get()).getDefaultInstance());
        this.localizedName = Component.translatableWithFallback((String)"gui.moresnifferflowers.corrupting_category", (String)"Corrupting");
    }

    public RecipeType<CorruptionRecipe> getRecipeType() {
        return CORRUPTING;
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 40;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CorruptionRecipe recipe, IFocusGroup iFocusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 15).addItemStack(recipe.source());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 15).addItemStack(recipe.corrupted())).addRichTooltipCallback((recipeSlotView, tooltip) -> {
            if (recipe.corrupted().isEmpty()) {
                tooltip.add((FormattedText)Component.literal((String)"Air").withStyle(ChatFormatting.WHITE));
            }
        });
    }

    public void draw(CorruptionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(MoreSnifferFlowers.loc("textures/gui/container/corrupting_jei.png"), 0, 0, 0, 0, this.getWidth(), this.getHeight());
        Minecraft minecraft = Minecraft.getInstance();
        String text = "Chance: " + recipe.chance() + "%";
        int width = minecraft.font.width(text);
        int x = this.getWidth() - 30 - width;
        int y = 0;
        guiGraphics.drawString(minecraft.font, text, x, y, 7424607, false);
    }
}

