/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.compat.jei.rebrewing;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;

public record JeiRebrewingRecipe(ItemStack extractedPotion, ItemStack rebrewedPotion, ItemStack ingredient) {
    public static List<JeiRebrewingRecipe> createRecipes() {
        ArrayList<JeiRebrewingRecipe> ret = new ArrayList<JeiRebrewingRecipe>();
        List<ItemStack> ingredients = List.of(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_AMPLIFIER.get()).getDefaultInstance(), ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_LENGTH.get()).getDefaultInstance(), ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_SPLASH.get()).getDefaultInstance(), ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_LINGERING.get()).getDefaultInstance());
        for (ItemStack item : ingredients) {
            BuiltInRegistries.MOB_EFFECT.stream().forEach(effect -> {
                int duration = item.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_LENGTH.get())) ? 12000 : 6000;
                int amplifier = item.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_AMPLIFIER.get())) ? 2 : 1;
                List<MobEffectInstance> extractedEffect = List.of(new MobEffectInstance(Holder.direct((Object)effect), 1200, 0));
                List<MobEffectInstance> rebrewedEffect = List.of(new MobEffectInstance(Holder.direct((Object)effect), 1200 + duration, amplifier));
                PotionContents extractedPotionContents = new PotionContents(Optional.of(Potions.WATER), Optional.of(PotionContents.getColor(extractedEffect)), extractedEffect);
                PotionContents rebrewedPotionContents = new PotionContents(Optional.of(Potions.WATER), Optional.of(PotionContents.getColor(rebrewedEffect)), rebrewedEffect);
                ItemStack extractedPotion = ((Item)ModItems.EXTRACTED_BOTTLE.get()).getDefaultInstance();
                ItemStack rebrewedPotion = item.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_SPLASH.get())) ? ((Item)ModItems.REBREWED_SPLASH_POTION.get()).getDefaultInstance() : (item.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_LINGERING.get())) ? ((Item)ModItems.REBREWED_LINGERING_POTION.get()).getDefaultInstance() : ((Item)ModItems.REBREWED_POTION.get()).getDefaultInstance());
                extractedPotion.set(DataComponents.POTION_CONTENTS, (Object)extractedPotionContents);
                rebrewedPotion.set(DataComponents.POTION_CONTENTS, (Object)rebrewedPotionContents);
                ret.add(new JeiRebrewingRecipe(extractedPotion, rebrewedPotion, item));
            });
        }
        return ret;
    }
}

