/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public enum DyespriaMode implements StringRepresentable
{
    SINGLE("single", DyespriaSelector::single, ChatFormatting.WHITE),
    COLUMN("column", DyespriaSelector::column, ChatFormatting.BLUE),
    ROW("row", DyespriaSelector::row, ChatFormatting.GREEN),
    SHAPE("shape", DyespriaSelector::shape, ChatFormatting.RED);

    public static final Codec<DyespriaMode> CODEC;
    public static final IntFunction<DyespriaMode> BY_ID;
    public static final StreamCodec<ByteBuf, DyespriaMode> STREAM_CODEC;
    private final String name;
    private final Function<DyespriaSelector, Set<BlockPos>> selector;
    private final ChatFormatting textColor;

    private DyespriaMode(String name, Function<DyespriaSelector, Set<BlockPos>> selector, ChatFormatting textColor) {
        this.name = name;
        this.selector = selector;
        this.textColor = textColor;
    }

    public static DyespriaMode byIndex(int index) {
        return BY_ID.apply(index);
    }

    public static DyespriaMode shift(DyespriaMode current, int amount) {
        int size = DyespriaMode.values().length;
        int currentIndex = current.ordinal();
        int newIndex = (currentIndex + amount) % size;
        return DyespriaMode.byIndex(newIndex);
    }

    public String getSerializedName() {
        return this.name;
    }

    public Function<DyespriaSelector, Set<BlockPos>> getSelector() {
        return this.selector;
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    static {
        CODEC = StringRepresentable.fromValues(DyespriaMode::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DyespriaMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }

    public record DyespriaSelector(BlockPos originalPos, BlockState blockState, @Nullable TagKey<Block> tag, Level level, Direction clickedDir, boolean isCrouching) {
        public Set<BlockPos> single() {
            return Set.of(this.originalPos());
        }

        public Set<BlockPos> column() {
            HashSet<BlockPos> ret = new HashSet<BlockPos>();
            ret.add(this.originalPos);
            BlockPos.MutableBlockPos posUp = this.originalPos.above().mutable();
            BlockPos.MutableBlockPos posDown = this.originalPos.below().mutable();
            while (this.matchBlock((BlockPos)posUp) && ret.size() <= 64) {
                ret.add(posUp.immutable());
                posUp.move(Direction.UP);
            }
            while (this.matchBlock((BlockPos)posDown) && ret.size() <= 64) {
                ret.add(posDown.immutable());
                posDown.move(Direction.DOWN);
            }
            return ret;
        }

        public Set<BlockPos> row() {
            HashSet<BlockPos> ret = new HashSet<BlockPos>();
            ret.add(this.originalPos);
            if (this.clickedDir == Direction.DOWN || this.clickedDir == Direction.UP) {
                return ret;
            }
            Direction rightDir = this.clickedDir.getCounterClockWise();
            Direction leftDir = this.clickedDir.getClockWise();
            BlockPos.MutableBlockPos posRight = this.originalPos.relative(rightDir).mutable();
            BlockPos.MutableBlockPos posDown = this.originalPos.relative(leftDir).mutable();
            while (this.matchBlock((BlockPos)posRight) && ret.size() <= 64) {
                ret.add(posRight.immutable());
                posRight.move(rightDir);
            }
            while (this.matchBlock((BlockPos)posDown) && ret.size() <= 64) {
                ret.add(posDown.immutable());
                posDown.move(leftDir);
            }
            return ret;
        }

        public Set<BlockPos> shape() {
            return BlockPos.withinManhattanStream((BlockPos)this.originalPos, (int)4, (int)4, (int)4).map(BlockPos::immutable).filter(this::matchBlock).collect(Collectors.toSet());
        }

        private boolean matchBlock(BlockPos pos) {
            boolean isColorableAndColored;
            BlockState state = this.level.getBlockState(pos);
            boolean isVanilla = DyespriaItem.checkDyedBlock(state);
            boolean bl = isColorableAndColored = state.is(this.blockState.getBlock()) && state.hasProperty(ModStateProperties.COLOR) && ((DyeColor)state.getValue(ModStateProperties.COLOR)).equals((Object)this.blockState.getValue(ModStateProperties.COLOR));
            if (BlockPatternCapability.hasPattern(this.originalPos, this.level)) {
                int thisId;
                if (!BlockPatternCapability.hasPattern(pos, this.level) || this.isCrouching) {
                    return false;
                }
                int originalId = BlockPatternCapability.getPattern(this.originalPos, this.level).patternId();
                return originalId == (thisId = BlockPatternCapability.getPattern(pos, this.level).patternId());
            }
            return isVanilla || isColorableAndColored || this.tag != null && this.level.getBlockState(pos).is(this.tag);
        }
    }
}

