/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.effects;

import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PantsOnFireEffect
extends MobEffect {
    public PantsOnFireEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Player player;
        Level level = livingEntity.level();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).hasEffect(ModEffects.PANTS_ON_FIRE) && !level.isClientSide) {
            int burnedSlots = 0;
            int maxBurnedSlots = 1 + 2 * amplifier;
            for (Slot slot : player.inventoryMenu.slots) {
                if (slot.getItem().is((Item)ModItems.BURNED_SLOT.get())) {
                    ++burnedSlots;
                }
                if (burnedSlots < maxBurnedSlots) continue;
                return true;
            }
            for (int i = 0; i < maxBurnedSlots - burnedSlots; ++i) {
                InventoryMenu menu = player.inventoryMenu;
                int slotId = level.random.nextIntBetweenInclusive(9, 35);
                Slot slot = menu.getSlot(slotId);
                if (slot.getItem().is((Item)ModItems.BURNED_SLOT.get())) {
                    return true;
                }
                ItemStack stack = slot.getItem();
                player.drop(stack, true);
                slot.set(((Item)ModItems.BURNED_SLOT.get()).getDefaultInstance());
            }
            level.playSound(null, (Entity)livingEntity, SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }
}

