/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities.goals;

import net.abraxator.moresnifferflowers.entities.BoblingEntity;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.SimpleAdvancementTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class BoblingAttackPlayerGoal
extends MeleeAttackGoal {
    private BoblingEntity bobling;

    public BoblingAttackPlayerGoal(BoblingEntity pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.bobling = pMob;
    }

    public boolean canUse() {
        return !this.bobling.isRunning() && super.canUse();
    }

    protected void checkAndPerformAttack(LivingEntity pTarget) {
        if (this.canPerformAttack(pTarget)) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)pTarget);
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof BoblingEntity) {
                BoblingEntity bobling = (BoblingEntity)pathfinderMob;
                if (pTarget instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pTarget;
                    ((SimpleAdvancementTrigger)((Object)ModAdvancementCritters.BOBLING_ATTACK.get())).trigger(serverPlayer);
                    bobling.setRunning(true);
                }
            }
        }
    }
}

