/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.List;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.SimpleAdvancementTrigger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class VivicusAntidoteItem
extends Item {
    public VivicusAntidoteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockPos relativePos = blockPos.relative(context.getClickedFace());
        BlockState blockState = level.getBlockState(blockPos);
        RandomSource random = level.getRandom();
        Player player = context.getPlayer();
        DustParticleOptions particle = new DustParticleOptions(Vec3.fromRGB24((int)7118872).toVector3f(), 1.0f);
        if (blockState.is((Block)ModBlocks.VIVICUS_SAPLING.get()) && !((Boolean)blockState.getValue((Property)ModStateProperties.VIVICUS_CURED)).booleanValue()) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)ModStateProperties.VIVICUS_CURED, (Comparable)Boolean.valueOf(true)));
            for (int i = 0; i <= 10; ++i) {
                level.addParticle((ParticleOptions)particle, (double)blockPos.getX() + random.nextDouble(), (double)blockPos.getY() + random.nextDouble(), (double)blockPos.getZ() + random.nextDouble(), 0.0, -0.3, 0.0);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((SimpleAdvancementTrigger)((Object)ModAdvancementCritters.USED_CURE.get())).trigger(serverPlayer);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (blockState.is((Block)ModBlocks.CORRUPTED_SLUDGE.get()) && ((Boolean)blockState.getValue((Property)ModStateProperties.CURED)).equals(false)) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)ModStateProperties.CURED, (Comparable)Boolean.valueOf(true)));
            for (int i = 0; i <= 10; ++i) {
                level.addParticle((ParticleOptions)particle, (double)relativePos.getX() + random.nextDouble(), (double)relativePos.getY() + random.nextDouble(), (double)relativePos.getZ() + random.nextDouble(), 0.0, -0.3, 0.0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (blockState.is((Block)ModBlocks.CORRUPTED_GRASS_BLOCK.get())) {
            level.setBlockAndUpdate(blockPos, ((Block)ModBlocks.CURED_GRASS_BLOCK.get()).defaultBlockState());
            for (int i = 0; i <= 10; ++i) {
                level.addParticle((ParticleOptions)particle, (double)relativePos.getX() + random.nextDouble(), (double)relativePos.getY() + random.nextDouble(), (double)relativePos.getZ() + random.nextDouble(), 0.0, -0.3, 0.0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> pTooltip, TooltipFlag pFlag) {
        super.appendHoverText(stack, context, pTooltip, pFlag);
        pTooltip.add((Component)Component.translatableWithFallback((String)"tooltip.wip", (String)"WIP").withStyle(ChatFormatting.DARK_RED));
        pTooltip.add((Component)Component.translatableWithFallback((String)"tooltip.vivicus_antidote", (String)"Cures Boblings and Corrupted Grass").withStyle(ChatFormatting.GOLD));
    }
}

