/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.mixins;

import net.abraxator.moresnifferflowers.init.ModStatePropertiesUnsafe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LeavesBlock.class})
public abstract class LeavesBlockMixin
extends Block
implements SimpleWaterloggedBlock {
    public LeavesBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"createBlockStateDefinition"}, at={@At(value="HEAD")})
    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        builder.add(new Property[]{ModStatePropertiesUnsafe.NOT_CORRUPTED}).add(new Property[]{ModStatePropertiesUnsafe.NOT_CURED});
    }

    @Inject(method={"updateShape"}, at={@At(value="TAIL")}, cancellable=true)
    public void updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> cir) {
        if (ModStatePropertiesUnsafe.hasCustomLeavesProperties(state) && ModStatePropertiesUnsafe.hasCustomLeavesProperties(facingState)) {
            boolean isCured;
            boolean isCorrupted = (Boolean)facingState.getValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED) == false;
            boolean bl = isCured = (Boolean)facingState.getValue((Property)ModStatePropertiesUnsafe.NOT_CURED) == false;
            if (isCorrupted) {
                cir.setReturnValue((Object)((BlockState)state.setValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED, (Comparable)Boolean.valueOf(false))));
            }
            if (isCured) {
                cir.setReturnValue((Object)((BlockState)((BlockState)state.setValue((Property)ModStatePropertiesUnsafe.NOT_CURED, (Comparable)Boolean.valueOf(false))).setValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED, (Comparable)Boolean.valueOf(true))));
            }
            if (!isCured && !isCorrupted) {
                cir.setReturnValue((Object)((BlockState)state.setValue((Property)ModStatePropertiesUnsafe.NOT_CURED, (Comparable)Boolean.valueOf(true))));
            }
        }
    }
}

