/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import io.netty.buffer.ByteBuf;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.SlipperyCapability;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.networking.MSFClientPacket;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public record SyncSlipperyPacket(SlipperyCapability capability, int entityId) implements MSFClientPacket
{
    public static final CustomPacketPayload.Type<SyncSlipperyPacket> TYPE = new CustomPacketPayload.Type(MoreSnifferFlowers.loc("sync_slippery"));
    public static final StreamCodec<ByteBuf, SyncSlipperyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec(SlipperyCapability.CODEC), SyncSlipperyPacket::capability, (StreamCodec)ByteBufCodecs.INT, SyncSlipperyPacket::entityId, SyncSlipperyPacket::new);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClientPacket(Player player, Level level) {
        Entity entity = level.getEntity(this.entityId);
        if (entity instanceof Player) {
            Player player1 = (Player)entity;
            SlipperyCapability cap = (SlipperyCapability)player1.getData(ModDataAttachments.SLIPPERY);
            cap.isFallen = this.capability.isFallen;
            cap.fallenTicks = this.capability.fallenTicks;
            cap.maxFallenTicks = this.capability.maxFallenTicks;
            if (!cap.isFallen) {
                cap.getUp(player1);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

