/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.nutrition;

import java.util.ArrayList;
import net.abraxator.moresnifferflowers.nutrition.Nutrition;
import net.abraxator.moresnifferflowers.nutrition.NutritionEntry;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NutritionStack {
    public ItemStack stack;
    public Nutrition nutrition;

    public NutritionStack(ItemStack stack, Nutrition nutrition) {
        this.stack = stack;
        this.nutrition = nutrition;
    }

    public CompoundTag serialize(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("itemStack", this.stack.save(provider));
        tag.putInt("nutritionEntries", this.nutrition.getNutritionEntries().size());
        for (int i = 0; i < this.nutrition.getNutritionEntries().size(); ++i) {
            NutritionEntry nutritionEntry = this.nutrition.getNutritionEntries().get(i);
            tag.put("nutritionEntry" + i, (Tag)nutritionEntry.serialize(new CompoundTag()));
        }
        return tag;
    }

    public static NutritionStack deserialize(CompoundTag tag, HolderLookup.Provider provider) {
        ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("itemStack"));
        int entries = tag.getInt("nutritionEntries");
        ArrayList<NutritionEntry> nutritionEntries = new ArrayList<NutritionEntry>();
        for (int i = 0; i < entries; ++i) {
            nutritionEntries.add(NutritionEntry.deserialize(tag.getCompound("nutritionEntry" + i)));
        }
        return new NutritionStack(itemStack, new Nutrition(itemStack.getItem(), nutritionEntries));
    }
}

