/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.corrupted;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CorruptedTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CorruptedTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(p_70161_ -> CorruptedTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)p_70161_).apply((Applicative)p_70161_, CorruptedTrunkPlacer::new));

    public CorruptedTrunkPlacer(int pBaseHeight, int pHeightRandA, int pBranchCount) {
        super(pBaseHeight, pHeightRandA, pBranchCount);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.CORRUPTED_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int pFreeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> ret = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int lastLogHeight = pFreeTreeHeight - (int)Mth.randomBetween((RandomSource)random, (float)2.0f, (float)3.0f);
        BlockPos.MutableBlockPos mainTrunk = pos.mutable();
        Object growthDir = null;
        int outerHeight = random.nextInt(3);
        int cornerHeight = outerHeight + (random.nextInt(2) - 1);
        int innerHeight = Math.min(outerHeight + random.nextIntBetweenInclusive(3, 5), pFreeTreeHeight - 2);
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            this.placeLog(level, blockSetter, random, (BlockPos)mainTrunk, config);
            if (i == pFreeTreeHeight - 1) {
                for (int branchOrder = 0; branchOrder < this.heightRandB; ++branchOrder) {
                    this.addBranch(mainTrunk.immutable(), ret, blockSetter, branchOrder, level, config, random, pFreeTreeHeight);
                }
            }
            if (i == 0) {
                this.fattenTrunk(level, blockSetter, random, pos, config, innerHeight, ret, cornerHeight, outerHeight);
            }
            mainTrunk.move(Direction.UP);
        }
        return ret;
    }

    private void fattenTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, int innerHeight, List<FoliagePlacer.FoliageAttachment> ret, int cornerHeight, int outerHeight) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            if (!(random.nextDouble() <= 0.9)) continue;
            BlockPos blockPosInner = pos.relative(direction);
            for (int j2 = 0; j2 < innerHeight; ++j2) {
                this.placeLog(level, blockSetter, random, blockPosInner.above(j2), config);
            }
            if (random.nextDouble() <= 0.9) {
                BlockPos blockPosCorner = blockPosInner.relative(random.nextDouble() > 0.5 ? direction.getClockWise() : direction.getCounterClockWise());
                for (j = 0; j < cornerHeight; ++j) {
                    this.placeLog(level, blockSetter, random, blockPosCorner.above(j), config);
                }
            }
            if (!(random.nextDouble() <= 0.9)) continue;
            BlockPos blockPosOuter = blockPosInner.relative(direction);
            for (j = 0; j < outerHeight; ++j) {
                this.placeLog(level, blockSetter, random, blockPosOuter.above(j), config);
            }
        }
    }

    private void addBranch(BlockPos blockPos, List<FoliagePlacer.FoliageAttachment> ret, BiConsumer<BlockPos, BlockState> blockSetter, int branchOrder, LevelSimulatedReader level, TreeConfiguration config, RandomSource random, int pFreeTreeHeight) {
        int v1;
        Direction direction = CorruptedTrunkPlacer.computeBranchDir(random);
        BlockPos.MutableBlockPos pos = blockPos.relative(direction).mutable();
        BlockPos.MutableBlockPos defaultPos = blockPos.relative(direction).mutable();
        int branchLength = Math.min(random.nextIntBetweenInclusive(5, 7), pFreeTreeHeight);
        int branchDir = (int)(360.0f / (float)this.heightRandB) * branchOrder;
        int n = branchOrder == 0 ? 1 : (v1 = branchOrder == 2 ? -1 : 0);
        int v3 = branchOrder == 1 ? 1 : (branchOrder == 3 ? -1 : 0);
        for (int x = 0; x < branchLength; ++x) {
            float branchHeightRand = (float)x / (float)branchLength;
            if (branchHeightRand < random.nextFloat() & branchHeightRand > 0.0f) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, 1, 0), config);
            }
            if ((double)branchHeightRand > (double)random.nextFloat() / 1.5 & branchHeightRand > 0.5f) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, -1, 0), config);
            }
            if (x == 0) {
                this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, 0, 0), config);
            }
            this.placeLog(level, blockSetter, random, (BlockPos)pos.move(v1, 0, v3), config);
            ret.add(new FoliagePlacer.FoliageAttachment(pos.above(), 0, false));
            if (x != branchLength - 1) continue;
            this.placeLog(level, blockSetter, random, (BlockPos)pos.move(0, -1, 0), config);
        }
    }

    private static Direction computeBranchDir(RandomSource random) {
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction clockAdjusted = random.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise();
        return random.nextBoolean() ? direction : clockAdjusted;
    }

    protected boolean validTreePos(LevelSimulatedReader level, BlockPos pos) {
        return (Boolean)ModServerConfig.CORRUPTED_TREE_GROW_THROUGH.get() != false || super.validTreePos(level, pos);
    }
}

