/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.abraxator.moresnifferflowers.worldgen.structures.ModStructureTypes;
import net.abraxator.moresnifferflowers.worldgen.structures.pieces.SwampSnifferTemplePieces;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class SwampSnifferTempleStructure
extends Structure {
    public static final MapCodec<SwampSnifferTempleStructure> CODEC = RecordCodecBuilder.mapCodec(swampSnifferTempleStructureInstance -> swampSnifferTempleStructureInstance.group((App)SwampSnifferTempleStructure.settingsCodec((RecordCodecBuilder.Instance)swampSnifferTempleStructureInstance)).apply((Applicative)swampSnifferTempleStructureInstance, SwampSnifferTempleStructure::new));

    protected SwampSnifferTempleStructure(Structure.StructureSettings pSettings) {
        super(pSettings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return SwampSnifferTempleStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, structurePiecesBuilder -> this.generatePieces((StructurePiecesBuilder)structurePiecesBuilder, context));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom worldgenRandom = context.random();
        int height = context.chunkGenerator().getFirstOccupiedHeight(chunkPos.x, chunkPos.z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()) + 3;
        BlockPos pos = new BlockPos(chunkPos.getMinBlockX(), 90, chunkPos.getMinBlockZ());
        Rotation rotation = Rotation.CLOCKWISE_90;
        SwampSnifferTemplePieces.addPieces(context.structureTemplateManager(), pos, rotation, (StructurePieceAccessor)builder, (RandomSource)worldgenRandom);
    }

    public StructureType<?> type() {
        return (StructureType)ModStructureTypes.SWAMP_SNIFFER_TEMPLE.get();
    }
}

