/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.structures.pieces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.init.ModBuiltinLoottables;
import net.abraxator.moresnifferflowers.worldgen.structures.pieces.ModPieceTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class SwampSnifferTemplePieces {
    public static final int GENERATION_HEIGHT = 90;
    public static final ResourceLocation BASE_LOCATION = MoreSnifferFlowers.loc("swamp_sniffer_temple/swamp_sniffer_temple_base");
    public static final List<ResourceLocation> CORNER_PIECES_LOCATION = List.of(MoreSnifferFlowers.loc("swamp_sniffer_temple/swamp_sniffer_temple_corner_1"), MoreSnifferFlowers.loc("swamp_sniffer_temple/swamp_sniffer_temple_corner_2"), MoreSnifferFlowers.loc("swamp_sniffer_temple/swamp_sniffer_temple_corner_3"), MoreSnifferFlowers.loc("swamp_sniffer_temple/swamp_sniffer_temple_corner_4"), MoreSnifferFlowers.loc("swamp_sniffer_temple/swamp_sniffer_temple_corner_5"), MoreSnifferFlowers.loc("swamp_sniffer_temple/swamp_sniffer_temple_corner_6"));
    public static final BlockPos PIVOT = new BlockPos(5, -2, -5);

    public static void addPieces(StructureTemplateManager pStructureTemplateManager, BlockPos pStartPos, Rotation pRotation, StructurePieceAccessor pPieces, RandomSource random) {
        int corner_chance = random.nextIntBetweenInclusive(2, 4);
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(CORNER_PIECES_LOCATION);
        Collections.shuffle(list);
        List<ResourceLocation> sublist = list.subList(0, 4);
        Rotation rotation = pRotation.getRotated(Rotation.CLOCKWISE_90);
        for (int i = 0; i < sublist.size(); ++i) {
            Direction dir = Direction.fromYRot((double)((i + 1) * 90));
            BlockPos piecePos = pStartPos.relative(dir, 1).relative(dir.getClockWise(), 1);
            pPieces.addPiece((StructurePiece)new SwampSnifferTemplePiece(pStructureTemplateManager, sublist.get(i), piecePos, rotation));
            rotation = rotation.getRotated(Rotation.CLOCKWISE_90);
        }
        pPieces.addPiece((StructurePiece)new SwampSnifferTemplePiece(pStructureTemplateManager, BASE_LOCATION, pStartPos.offset(4, -3, -4), pRotation));
    }

    public static class SwampSnifferTemplePiece
    extends TemplateStructurePiece {
        public SwampSnifferTemplePiece(StructureTemplateManager pStructureTemplateManager, ResourceLocation pLocation, BlockPos startPos, Rotation rotation) {
            super((StructurePieceType)ModPieceTypes.SWAMP_SNIFFER_TEMPLE.get(), 0, pStructureTemplateManager, pLocation, pLocation.toString(), SwampSnifferTemplePiece.makeSettings(rotation, pLocation), startPos);
        }

        public SwampSnifferTemplePiece(StructureTemplateManager structureTemplateManager, CompoundTag tag) {
            super((StructurePieceType)ModPieceTypes.SWAMP_SNIFFER_TEMPLE.get(), tag, structureTemplateManager, resourceLocation -> SwampSnifferTemplePiece.makeSettings(Rotation.valueOf((String)tag.getString("Rot")), resourceLocation));
        }

        private static StructurePlaceSettings makeSettings(Rotation rot, ResourceLocation resourceLocation) {
            return new StructurePlaceSettings().setRotation(rot).setMirror(Mirror.NONE).addProcessor(SwampSnifferTemplePiece.suspiciateGravel()).addProcessor(SwampSnifferTemplePiece.addMoss()).addProcessor(SwampSnifferTemplePiece.addChest());
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putString("Rot", this.placeSettings.getRotation().name());
        }

        public void postProcess(WorldGenLevel level, StructureManager pStructureManager, ChunkGenerator pGenerator, RandomSource random, BoundingBox pBox, ChunkPos pChunkPos, BlockPos pos) {
            int i = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.templatePosition.getX(), this.templatePosition.getZ());
            this.templatePosition = this.templatePosition.offset(0, i - 90, 0);
            super.postProcess(level, pStructureManager, pGenerator, random, pBox, pChunkPos, pos);
        }

        protected void handleDataMarker(String pName, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox pBox) {
        }

        private static StructureProcessor suspiciateGravel() {
            return new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.GRAVEL), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)PosAlwaysTrueTest.INSTANCE, Blocks.SUSPICIOUS_GRAVEL.defaultBlockState(), (RuleBlockEntityModifier)new AppendLoot(ModBuiltinLoottables.SWAMP_SNIFFER_TEMPLE)))), (IntProvider)UniformInt.of((int)4, (int)6));
        }

        private static StructureProcessor addMoss() {
            return new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.MOSS_BLOCK, 0.8f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.MANGROVE_ROOTS, 0.4f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.MOSS_BLOCK.defaultBlockState()))), (IntProvider)ConstantInt.of((int)6));
        }

        private static StructureProcessor addChest() {
            return new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.CHEST), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)PosAlwaysTrueTest.INSTANCE, Blocks.CHEST.defaultBlockState(), (RuleBlockEntityModifier)new AppendLoot(ModBuiltinLoottables.SWAMP_SNIFFER_TEMPLE_CHEST)))), (IntProvider)UniformInt.of((int)4, (int)6));
        }
    }
}

