/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.randomEvents;

import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EventManager {
    private final JavaPlugin plugin;
    private final Random random = new Random();

    public EventManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void triggerRandomEvent() {
        List worlds = Bukkit.getWorlds();
        if (worlds.isEmpty()) {
            return;
        }
        World world = (World)worlds.get(0);
        List players = world.getPlayers();
        if (players.isEmpty()) {
            return;
        }
        int eventIndex = this.random.nextInt(20);
        switch (eventIndex) {
            case 0: {
                this.startMeteorShower(world);
                break;
            }
            case 1: {
                this.startZombieSiege(world);
                break;
            }
            case 2: {
                this.startTreasureHunt(world);
                break;
            }
            case 3: {
                this.startSuperchargedNight(world);
                break;
            }
            case 4: {
                this.startRainbowSky(world);
                break;
            }
            case 5: {
                this.startSuddenDrought(world);
                break;
            }
            case 6: {
                this.startMeteorStrike(world);
                break;
            }
            case 7: {
                this.startDarkFog(world);
                break;
            }
            case 8: {
                this.startTimeFreeze(world);
                break;
            }
            case 9: {
                this.startGravityShift(world);
                break;
            }
            case 10: {
                this.startSolarEclipse(world);
                break;
            }
            case 11: {
                this.startChasmOpening(world);
                break;
            }
            case 12: {
                this.startThunderstormWithTornadoes(world);
                break;
            }
            case 13: {
                this.startEnderworldShift(world);
                break;
            }
            case 14: {
                this.startRainbowFireworks(world);
                break;
            }
            case 15: {
                this.startStormOfShards(world);
                break;
            }
            case 16: {
                this.startSuddenFlood(world);
                break;
            }
            case 17: {
                this.startSupermoon(world);
                break;
            }
            case 18: {
                this.startEnderworldShift(world);
                break;
            }
            case 19: {
                this.startRainbowFireworks(world);
                break;
            }
        }
    }

    private void startMeteorShower(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A meteor shower has begun!");
        for (Player player : world.getPlayers()) {
            for (int i = 0; i < 10; ++i) {
                world.spawn(player.getLocation().add((double)(this.random.nextInt(50) - 25), 50.0, (double)(this.random.nextInt(50) - 25)), Fireball.class);
            }
        }
    }

    private void startZombieSiege(World world) {
        Bukkit.broadcastMessage((String)"\u00a7cA zombie siege is approaching!");
        for (Player player : world.getPlayers()) {
            for (int i = 0; i < 10; ++i) {
                world.spawn(player.getLocation().add((double)(this.random.nextInt(10) - 5), 0.0, (double)(this.random.nextInt(10) - 5)), Zombie.class);
            }
        }
    }

    private void startTreasureHunt(World world) {
        Bukkit.broadcastMessage((String)"\u00a7aA treasure chest has been hidden nearby!");
        for (Player player : world.getPlayers()) {
            Location chestLocation = player.getLocation().add((double)(this.random.nextInt(20) - 10), 0.0, (double)(this.random.nextInt(20) - 10));
            chestLocation.setY((double)world.getHighestBlockYAt(chestLocation));
            world.getBlockAt(chestLocation).setType(Material.CHEST);
            Chest chest = (Chest)world.getBlockAt(chestLocation).getState();
            Inventory chestInventory = chest.getBlockInventory();
            chestInventory.addItem(new ItemStack[]{new ItemStack(Material.DIAMOND, 3)});
            chestInventory.addItem(new ItemStack[]{new ItemStack(Material.GOLD_INGOT, 5)});
        }
    }

    private void startSuperchargedNight(World world) {
        Bukkit.broadcastMessage((String)"\u00a75A supercharged night has begun!");
        for (Player player : world.getPlayers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 6000, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 6000, 1));
        }
    }

    private void startRainbowSky(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A beautiful rainbow sky has appeared!");
        for (Player player : world.getPlayers()) {
            player.sendTitle("\u00a76Rainbow Sky!", "Enjoy the view!", 10, 70, 20);
        }
    }

    private void startSuddenDrought(World world) {
        Bukkit.broadcastMessage((String)"\u00a7cA sudden drought has begun, water sources are drying up!");
        for (World world1 : Bukkit.getWorlds()) {
            for (Entity entity : world1.getEntities()) {
                if (!(entity instanceof WaterMob)) continue;
                entity.remove();
            }
        }
    }

    private void startMeteorStrike(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A meteor has struck the ground!");
        world.spawn(world.getSpawnLocation().add((double)(this.random.nextInt(50) - 25), 100.0, (double)(this.random.nextInt(50) - 25)), Fireball.class);
    }

    private void startDarkFog(World world) {
        Bukkit.broadcastMessage((String)"\u00a77A dark fog has covered the land!");
        for (Player player : world.getPlayers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 600, 1));
        }
    }

    private void startTimeFreeze(World world) {
        Bukkit.broadcastMessage((String)"\u00a7bTime has frozen for a moment!");
        for (Player player : world.getPlayers()) {
            player.setWalkSpeed(0.0f);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            for (Player player : world.getPlayers()) {
                player.setWalkSpeed(0.2f);
            }
        }, 200L);
    }

    private void startGravityShift(World world) {
        Bukkit.broadcastMessage((String)"\u00a75Gravity has shifted!");
        for (Player player : world.getPlayers()) {
            player.setGravity(false);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            for (Player player : world.getPlayers()) {
                player.setGravity(true);
            }
        }, 200L);
    }

    private void startSolarEclipse(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A solar eclipse is occurring!");
        world.setStorm(true);
        world.setThundering(true);
    }

    private void startChasmOpening(World world) {
        Bukkit.broadcastMessage((String)"\u00a7cA chasm has opened in the world!");
        Location loc = world.getSpawnLocation();
        for (int y = 0; y < 10; ++y) {
            for (int x = -20; x < 20; ++x) {
                for (int z = -20; z < 20; ++z) {
                    world.getBlockAt(loc.clone().add((double)x, (double)(-y), (double)z)).setType(Material.AIR);
                }
            }
        }
    }

    private void startThunderstormWithTornadoes(World world) {
        Bukkit.broadcastMessage((String)"\u00a77A thunderstorm with tornadoes has appeared!");
        world.setStorm(true);
        world.setThundering(true);
    }

    private void startEnderworldShift(World world) {
        Bukkit.broadcastMessage((String)"\u00a75An Enderworld Shift has occurred!");
    }

    private void startRainbowFireworks(World world) {
        Bukkit.broadcastMessage((String)"\u00a76Rainbow Fireworks are going off!");
        world.spawn(world.getSpawnLocation(), Firework.class);
    }

    private void startStormOfShards(World world) {
        Bukkit.broadcastMessage((String)"\u00a77A storm of shards is raining down!");
    }

    private void startSuddenFlood(World world) {
        Bukkit.broadcastMessage((String)"\u00a7bA sudden flood is happening!");
    }

    private void startSupermoon(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A Supermoon is shining brightly!");
    }
}

