/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.randomEvents;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RandomEvents
extends JavaPlugin {
    private final Random random = new Random();

    public void onEnable() {
        this.getLogger().info("RandomEvents plugin enabled!");
        this.getCommand("triggerRandomEvent").setExecutor((CommandExecutor)this);
    }

    public void onDisable() {
        this.getLogger().info("RandomEvents plugin disabled!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("triggerRandomEvent")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                World world = player.getWorld();
                this.triggerRandomEvent(world);
                player.sendMessage("\u00a7aA random event has been triggered!");
                return true;
            }
            sender.sendMessage("\u00a7cThis command can only be used by a player.");
            return false;
        }
        return false;
    }

    public void triggerRandomEvent(World world) {
        int eventId = this.random.nextInt(15);
        switch (eventId) {
            case 0: {
                this.startSuperchargedNight(world);
                break;
            }
            case 1: {
                this.startRainbowSky(world);
                break;
            }
            case 2: {
                this.startSuddenDrought(world);
                break;
            }
            case 3: {
                this.startMeteorStrike(world);
                break;
            }
            case 4: {
                this.startDarkFog(world);
                break;
            }
            case 5: {
                this.startTimeFreeze(world);
                break;
            }
            case 6: {
                this.startGravityShift(world);
                break;
            }
            case 7: {
                this.startSolarEclipse(world);
                break;
            }
            case 8: {
                this.startChasmOpening(world);
                break;
            }
            case 9: {
                this.startThunderstormWithTornadoes(world);
                break;
            }
            case 10: {
                this.startEnderworldShift(world);
                break;
            }
            case 11: {
                this.startRainbowFireworks(world);
                break;
            }
            case 12: {
                this.startStormOfShards(world);
                break;
            }
            case 13: {
                this.startSuddenFlood(world);
                break;
            }
            case 14: {
                this.startSupermoon(world);
            }
        }
    }

    public void startSuperchargedNight(World world) {
        Bukkit.broadcastMessage((String)"\u00a75A supercharged night has begun!");
        for (Player player : world.getPlayers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 6000, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 6000, 1));
        }
    }

    public void startRainbowSky(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A beautiful rainbow sky has appeared!");
        for (Player player : world.getPlayers()) {
            player.sendTitle("\u00a76Rainbow Sky!", "Enjoy the view!", 10, 70, 20);
        }
    }

    public void startSuddenDrought(World world) {
        Bukkit.broadcastMessage((String)"\u00a7cA sudden drought has begun, water sources are drying up!");
        for (Player player : world.getPlayers()) {
            world.getBlockAt(player.getLocation()).setType(Material.AIR);
        }
    }

    public void startMeteorStrike(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A meteor has struck the ground!");
        world.spawn(world.getSpawnLocation().add((double)(this.random.nextInt(50) - 25), 100.0, (double)(this.random.nextInt(50) - 25)), Fireball.class);
    }

    public void startDarkFog(World world) {
        Bukkit.broadcastMessage((String)"\u00a77A dark fog has covered the land!");
        for (Player player : world.getPlayers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 600, 1));
        }
    }

    public void startTimeFreeze(World world) {
        Bukkit.broadcastMessage((String)"\u00a7bTime has frozen for a moment!");
        for (Player player : world.getPlayers()) {
            player.setWalkSpeed(0.0f);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            for (Player player : world.getPlayers()) {
                player.setWalkSpeed(0.2f);
            }
        }, 200L);
    }

    public void startGravityShift(World world) {
        Bukkit.broadcastMessage((String)"\u00a75Gravity has shifted!");
        for (Player player : world.getPlayers()) {
            player.setGravity(false);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            for (Player player : world.getPlayers()) {
                player.setGravity(true);
            }
        }, 200L);
    }

    public void startSolarEclipse(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A solar eclipse is occurring!");
        world.setStorm(true);
        world.setThundering(true);
    }

    public void startChasmOpening(World world) {
        Bukkit.broadcastMessage((String)"\u00a7cA chasm has opened in the world!");
        Location loc = world.getSpawnLocation();
        for (int y = 0; y < 10; ++y) {
            for (int x = -20; x < 20; ++x) {
                for (int z = -20; z < 20; ++z) {
                    world.getBlockAt(loc.clone().add((double)x, (double)(-y), (double)z)).setType(Material.AIR);
                }
            }
        }
    }

    public void startThunderstormWithTornadoes(World world) {
        Bukkit.broadcastMessage((String)"\u00a77A thunderstorm with tornadoes has appeared!");
        world.setStorm(true);
        world.setThundering(true);
    }

    public void startEnderworldShift(World world) {
        Bukkit.broadcastMessage((String)"\u00a75An Enderworld shift has begun!");
        for (Player player : world.getPlayers()) {
            player.teleport(world.getSpawnLocation());
        }
    }

    public void startRainbowFireworks(World world) {
        Bukkit.broadcastMessage((String)"\u00a76Rainbow fireworks are lighting up the sky!");
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            for (int i = 0; i < 10; ++i) {
                world.spawn(world.getSpawnLocation().add((double)(this.random.nextInt(50) - 25), 100.0, (double)(this.random.nextInt(50) - 25)), Fireball.class);
            }
        }, 0L);
    }

    public void startStormOfShards(World world) {
        Bukkit.broadcastMessage((String)"\u00a77A storm of shards is raining down!");
        for (int i = 0; i < 20; ++i) {
            world.spawn(world.getSpawnLocation().add((double)(this.random.nextInt(50) - 25), 100.0, (double)(this.random.nextInt(50) - 25)), Arrow.class);
        }
    }

    public void startSuddenFlood(World world) {
        Bukkit.broadcastMessage((String)"\u00a7bA sudden flood is sweeping through!");
        for (int x = -50; x < 50; ++x) {
            for (int z = -50; z < 50; ++z) {
                world.getBlockAt(world.getSpawnLocation().add((double)x, 0.0, (double)z)).setType(Material.WATER);
            }
        }
    }

    public void startSupermoon(World world) {
        Bukkit.broadcastMessage((String)"\u00a7dA Supermoon has appeared!");
        world.setFullTime(8L);
        for (Player player : world.getPlayers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 6000, 1));
        }
    }
}

