/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.randomEvents;

import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class RandomEvents {
    private JavaPlugin plugin;
    private final Random random = new Random();

    public void EventManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public RandomEvents(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void triggerRandomEvent() {
        List worlds = Bukkit.getWorlds();
        if (worlds.isEmpty()) {
            return;
        }
        World world = (World)worlds.get(0);
        List players = world.getPlayers();
        if (players.isEmpty()) {
            return;
        }
        int eventIndex = this.random.nextInt(3);
        switch (eventIndex) {
            case 0: {
                this.startMeteorShower(world);
                break;
            }
            case 1: {
                this.startZombieSiege(world);
                break;
            }
            case 2: {
                this.startTreasureHunt(world);
                break;
            }
        }
    }

    private void startMeteorShower(World world) {
        Bukkit.broadcastMessage((String)"\u00a76A meteor shower has begun!");
        for (Player player : world.getPlayers()) {
            for (int i = 0; i < 10; ++i) {
                world.spawn(player.getLocation().add((double)(this.random.nextInt(50) - 25), 50.0, (double)(this.random.nextInt(50) - 25)), Fireball.class);
            }
        }
    }

    private void startZombieSiege(World world) {
        Bukkit.broadcastMessage((String)"\u00a7cA zombie siege is approaching!");
        for (Player player : world.getPlayers()) {
            for (int i = 0; i < 10; ++i) {
                world.spawn(player.getLocation().add((double)(this.random.nextInt(10) - 5), 0.0, (double)(this.random.nextInt(10) - 5)), Zombie.class);
            }
        }
    }

    private void startTreasureHunt(World world) {
        Bukkit.broadcastMessage((String)"\u00a7aA treasure chest has been hidden nearby!");
        for (Player player : world.getPlayers()) {
            Location chestLocation = player.getLocation().add((double)(this.random.nextInt(20) - 10), 0.0, (double)(this.random.nextInt(20) - 10));
            chestLocation.setY((double)world.getHighestBlockYAt(chestLocation));
            world.getBlockAt(chestLocation).setType(Material.CHEST);
            Chest chest = (Chest)world.getBlockAt(chestLocation).getState();
            Inventory chestInventory = chest.getBlockInventory();
            chestInventory.addItem(new ItemStack[]{new ItemStack(Material.DIAMOND, 3)});
            chestInventory.addItem(new ItemStack[]{new ItemStack(Material.GOLD_INGOT, 5)});
        }
    }
}

