/*
 * Decompiled with CFR 0.152.
 */
package mod.swift.snowysniffer.mixin;

import mod.swift.snowysniffer.interfaces.MaybeSnowy;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"interactLivingEntity"}, cancellable=true)
    private void shovelSnifferInteraction(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        MaybeSnowy snowy;
        if (!livingEntity.level().isClientSide() && itemStack.getItem() instanceof ShovelItem && livingEntity instanceof MaybeSnowy && (snowy = (MaybeSnowy)livingEntity).isSnowy()) {
            snowy.setSnowy(false);
            int numberOfSnowballs = livingEntity.isBaby() ? 3 : 6 + livingEntity.getRandom().nextInt(3);
            for (int i = 0; i < numberOfSnowballs; ++i) {
                ItemStack stack = Items.SNOWBALL.getDefaultInstance();
                ItemEntity itemEntity = new ItemEntity(livingEntity.level(), livingEntity.getRandomX(0.75), livingEntity.getRandomY(), livingEntity.getRandomZ(0.75), stack);
                itemEntity.setDefaultPickUpDelay();
                livingEntity.level().addFreshEntity((Entity)itemEntity);
            }
            livingEntity.playSound(SoundEvents.SNOW_BREAK);
            itemStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

