/*
 * Decompiled with CFR 0.152.
 */
package mod.swift.snowysniffer.mixin;

import java.util.Objects;
import mod.swift.snowysniffer.interfaces.MaybeSnowy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Sniffer.class})
public abstract class SnifferEntityMixin
extends Entity
implements MaybeSnowy {
    @Unique
    private static final EntityDataAccessor<Boolean> HAS_SNOW = SynchedEntityData.defineId(Sniffer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Unique
    private static final EntityDataAccessor<Boolean> LOADED_ON_SERVER = SynchedEntityData.defineId(Sniffer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void injectData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(HAS_SNOW, (Object)false);
        builder.define(LOADED_ON_SERVER, (Object)false);
    }

    public SnifferEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo ci) {
        if (this.level().isClientSide()) {
            return;
        }
        if (!this.level().isClientSide()) {
            this.entityData.set(LOADED_ON_SERVER, (Object)true);
        }
        if (this.isInPowderSnow && !this.isSnowy()) {
            this.setSnowy(true);
        } else if (this.isEyeInFluid(FluidTags.WATER) && this.isSnowy()) {
            this.setSnowy(false);
        }
        if (this.shouldSetHasSnowToTrue()) {
            this.entityData.set(HAS_SNOW, (Object)true);
        } else if (this.shouldRemoveHasSnow()) {
            this.entityData.set(HAS_SNOW, (Object)false);
        }
        if (this.random.nextInt(240) == 0 && this.closeToHeat()) {
            this.entityData.set(HAS_SNOW, (Object)false);
        }
    }

    @Unique
    private boolean closeToHeat() {
        int maxCheckDistance = 3;
        for (BlockPos blockPos : BlockPos.betweenClosed((int)(this.getBlockX() - maxCheckDistance), (int)(this.getBlockY() - maxCheckDistance), (int)(this.getBlockZ() - maxCheckDistance), (int)(this.getBlockX() + maxCheckDistance), (int)(this.getBlockY() + maxCheckDistance), (int)(this.getBlockZ() + maxCheckDistance))) {
            BlockState blockState = this.level().getBlockState(blockPos);
            if (!blockState.getFluidState().is((Fluid)Fluids.LAVA) && !blockState.is(Blocks.CAMPFIRE) && !blockState.is(Blocks.FIRE)) continue;
            return true;
        }
        return false;
    }

    @Inject(at={@At(value="HEAD")}, method={"onSyncedDataUpdated"})
    private void updateSnowy(EntityDataAccessor<?> entityDataAccessor, CallbackInfo ci) {
        if (HAS_SNOW.equals(entityDataAccessor) && !this.isSnowy()) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.SNOWFLAKE);
        }
    }

    @Unique
    protected void addParticlesAroundSelf(ParticleOptions particleOptions) {
        for (int i = 0; i < 60; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double e = this.random.nextGaussian() * 0.02;
            double f = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particleOptions, this.getRandomX(0.75), this.getRandomY() + 0.75, this.getRandomZ(0.75), d, e, f);
        }
    }

    @Unique
    private boolean isSnowingAt() {
        Level level = this.level();
        BlockPos blockPos = this.blockPosition();
        if (!level.isRaining()) {
            return false;
        }
        if (!level.canSeeSky(blockPos)) {
            return false;
        }
        if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).getY() > blockPos.getY()) {
            return false;
        }
        Biome biome = (Biome)level.getBiome(blockPos).value();
        return biome.coldEnoughToSnow(blockPos, this.level().getSeaLevel());
    }

    @Override
    public void setSnowy(boolean snowy) {
        this.entityData.set(HAS_SNOW, (Object)snowy);
    }

    @Override
    public boolean isSnowy() {
        if (((Boolean)this.entityData.get(LOADED_ON_SERVER)).booleanValue()) {
            return (Boolean)this.entityData.get(HAS_SNOW);
        }
        return Objects.equals(this.getCustomName(), Component.literal((String)"Snowy")) || this.isSnowingAt();
    }

    @Unique
    private boolean shouldSetHasSnowToTrue() {
        return this.isSnowingAt() && !this.isSnowy();
    }

    @Unique
    private boolean shouldRemoveHasSnow() {
        return this.isSnowy() && (this.isTooHot() || this.level().isRainingAt(this.blockPosition()));
    }

    @Unique
    private boolean isTooHot() {
        return ((Biome)this.level().getBiome(this.blockPosition()).value()).getBaseTemperature() > 1.0f;
    }
}

