/*
 * Decompiled with CFR 0.152.
 */
package mod.swift.snowysniffer.mixin;

import mod.swift.snowysniffer.interfaces.MaybeSnowy;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Animal.class})
public class SnifferNbtMixin {
    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    private void addSnowySaveData(ValueOutput output, CallbackInfo ci) {
        SnifferNbtMixin snifferNbtMixin = this;
        if (snifferNbtMixin instanceof MaybeSnowy) {
            MaybeSnowy maybeSnowy = (MaybeSnowy)((Object)snifferNbtMixin);
            output.putBoolean("Snowy", maybeSnowy.isSnowy());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    private void readSnowySaveData(ValueInput input, CallbackInfo ci) {
        SnifferNbtMixin snifferNbtMixin = this;
        if (snifferNbtMixin instanceof MaybeSnowy) {
            MaybeSnowy maybeSnowy = (MaybeSnowy)((Object)snifferNbtMixin);
            maybeSnowy.setSnowy(input.getBooleanOr("Snowy", false));
        }
    }
}

