/*
 * Decompiled with CFR 0.152.
 */
package mod.swift.snowysniffer.mixin;

import java.util.Objects;
import mod.swift.snowysniffer.interfaces.MaybeSnowy;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_8153;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_8153.class})
public abstract class SnifferEntityMixin
extends class_1297
implements MaybeSnowy {
    @Unique
    private static final class_2940<Boolean> HAS_SNOW = class_2945.method_12791(class_8153.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> LOADED_ON_SERVER = class_2945.method_12791(class_8153.class, (class_2941)class_2943.field_13323);

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void injectData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(HAS_SNOW, (Object)false);
        builder.method_56912(LOADED_ON_SERVER, (Object)false);
    }

    public SnifferEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo ci) {
        if (this.method_37908().method_8608()) {
            return;
        }
        if (!this.method_37908().method_8608()) {
            this.field_6011.method_12778(LOADED_ON_SERVER, (Object)true);
        }
        if (this.field_27857 && !this.isSnowy()) {
            this.setSnowy(true);
        } else if (this.method_5777(class_3486.field_15517) && this.isSnowy()) {
            this.setSnowy(false);
        }
        if (this.shouldSetHasSnowToTrue()) {
            this.field_6011.method_12778(HAS_SNOW, (Object)true);
        } else if (this.shouldRemoveHasSnow()) {
            this.field_6011.method_12778(HAS_SNOW, (Object)false);
        }
        if (this.field_5974.method_43048(240) == 0 && this.closeToHeat()) {
            this.field_6011.method_12778(HAS_SNOW, (Object)false);
        }
    }

    @Unique
    private boolean closeToHeat() {
        int maxCheckDistance = 3;
        for (class_2338 blockPos : class_2338.method_10094((int)(this.method_31477() - maxCheckDistance), (int)(this.method_31478() - maxCheckDistance), (int)(this.method_31479() - maxCheckDistance), (int)(this.method_31477() + maxCheckDistance), (int)(this.method_31478() + maxCheckDistance), (int)(this.method_31479() + maxCheckDistance))) {
            class_2680 blockState = this.method_37908().method_8320(blockPos);
            if (!blockState.method_26227().method_39360((class_3611)class_3612.field_15908) && !blockState.method_27852(class_2246.field_17350) && !blockState.method_27852(class_2246.field_10036)) continue;
            return true;
        }
        return false;
    }

    @Inject(at={@At(value="HEAD")}, method={"onSyncedDataUpdated"})
    private void updateSnowy(class_2940<?> entityDataAccessor, CallbackInfo ci) {
        if (HAS_SNOW.equals(entityDataAccessor) && !this.isSnowy()) {
            this.addParticlesAroundSelf((class_2394)class_2398.field_28013);
        }
    }

    @Unique
    protected void addParticlesAroundSelf(class_2394 particleOptions) {
        for (int i = 0; i < 60; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406(particleOptions, this.method_23322(0.75), this.method_23319() + 0.75, this.method_23325(0.75), d, e, f);
        }
    }

    @Unique
    private boolean isSnowingAt() {
        class_1937 level = this.method_37908();
        class_2338 blockPos = this.method_24515();
        if (!level.method_8419()) {
            return false;
        }
        if (!level.method_8311(blockPos)) {
            return false;
        }
        if (level.method_8598(class_2902.class_2903.field_13197, blockPos).method_10264() > blockPos.method_10264()) {
            return false;
        }
        class_1959 biome = (class_1959)level.method_23753(blockPos).comp_349();
        return biome.method_33599(blockPos, this.method_37908().method_8615());
    }

    @Override
    public void setSnowy(boolean snowy) {
        this.field_6011.method_12778(HAS_SNOW, (Object)snowy);
    }

    @Override
    public boolean isSnowy() {
        if (((Boolean)this.field_6011.method_12789(LOADED_ON_SERVER)).booleanValue()) {
            return (Boolean)this.field_6011.method_12789(HAS_SNOW);
        }
        return Objects.equals(this.method_5797(), class_2561.method_43470((String)"Snowy")) || this.isSnowingAt();
    }

    @Unique
    private boolean shouldSetHasSnowToTrue() {
        return this.isSnowingAt() && !this.isSnowy();
    }

    @Unique
    private boolean shouldRemoveHasSnow() {
        return this.isSnowy() && (this.isTooHot() || this.method_37908().method_8520(this.method_24515()));
    }

    @Unique
    private boolean isTooHot() {
        return ((class_1959)this.method_37908().method_23753(this.method_24515()).comp_349()).method_8712() > 1.0f;
    }
}

