/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.netty;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.util.Natives;
import io.github.kosmx.emotes.mc.McUtils;
import io.github.kosmx.emotes.server.config.Serializer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.redlance.dima_dencep.mods.online_emotes.OnlineEmotes;
import org.redlance.dima_dencep.mods.online_emotes.OnlineEmotesConfig;
import org.redlance.dima_dencep.mods.online_emotes.client.FancyToast;
import org.redlance.dima_dencep.mods.online_emotes.netty.compression.VelocityCompressDecoder;
import org.redlance.dima_dencep.mods.online_emotes.netty.compression.VelocityCompressEncoder;
import org.redlance.dima_dencep.mods.online_emotes.network.OnlineNetworkInstance;

@ChannelHandler.Sharable
public class WebsocketHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final class_2561 DISCONNECTED = class_2561.method_43471((String)"online_emotes.messages.disconnected");
    private static final class_2561 CONNECTED = class_2561.method_43471((String)"online_emotes.messages.connected");
    private static final class_2561 COMPRESSIONOFF = class_2561.method_43471((String)"online_emotes.messages.compressionoff");
    private final OnlineNetworkInstance proxy;

    public WebsocketHandler(OnlineNetworkInstance proxy) {
        this.proxy = proxy;
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (OnlineEmotesConfig.debug()) {
            FancyToast.sendMessage(DISCONNECTED);
        }
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (OnlineEmotesConfig.debug()) {
            FancyToast.sendMessage(CONNECTED);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) {
        WebSocketFrame webSocketFrame = msg;
        Objects.requireNonNull(webSocketFrame);
        WebSocketFrame webSocketFrame2 = webSocketFrame;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinaryWebSocketFrame.class, TextWebSocketFrame.class, PingWebSocketFrame.class, CloseWebSocketFrame.class}, (Object)webSocketFrame2, n)) {
            case 0: {
                BinaryWebSocketFrame frame = (BinaryWebSocketFrame)webSocketFrame2;
                ByteBuf buf = frame.content();
                if (!buf.isDirect() && !buf.isReadOnly()) {
                    this.proxy.receiveMessage(buf.array());
                    break;
                }
                byte[] bytes = new byte[buf.readableBytes()];
                buf.getBytes(buf.readerIndex(), bytes);
                this.proxy.receiveMessage(bytes);
                break;
            }
            case 1: {
                TextWebSocketFrame frame = (TextWebSocketFrame)webSocketFrame2;
                JsonElement element = (JsonElement)Serializer.getSerializer().fromJson(frame.text(), JsonElement.class);
                if (!element.isJsonObject()) {
                    FancyToast.sendMessage(McUtils.fromJson((Object)element, (class_7225.class_7874)class_5455.field_40585));
                    break;
                }
                JsonObject object = element.getAsJsonObject();
                if (object.has("message")) {
                    FancyToast.sendMessage(McUtils.fromJson((Object)object.get("message"), (class_7225.class_7874)class_5455.field_40585));
                }
                if (!object.has("compression")) break;
                int compressionLevel = object.get("compression").getAsInt();
                if (compressionLevel <= 0) {
                    if (ctx.pipeline().get("velocity-decompressor") instanceof VelocityCompressDecoder) {
                        ctx.pipeline().remove("velocity-decompressor");
                    }
                    if (ctx.pipeline().get("velocity-compressor") instanceof VelocityCompressEncoder) {
                        ctx.pipeline().remove("velocity-compressor");
                    }
                    if (!OnlineEmotesConfig.debug()) break;
                    FancyToast.sendMessage(COMPRESSIONOFF);
                    break;
                }
                VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(compressionLevel);
                ChannelHandler channelHandler = ctx.pipeline().get("velocity-decompressor");
                if (channelHandler instanceof VelocityCompressDecoder) {
                    VelocityCompressDecoder decoder = (VelocityCompressDecoder)channelHandler;
                    ctx.pipeline().replace((ChannelHandler)decoder, "velocity-decompressor", (ChannelHandler)new VelocityCompressDecoder(compressor));
                } else {
                    ctx.pipeline().addAfter("ws-decoder", "velocity-decompressor", (ChannelHandler)new VelocityCompressDecoder(compressor));
                }
                channelHandler = ctx.pipeline().get("velocity-compressor");
                if (channelHandler instanceof VelocityCompressEncoder) {
                    VelocityCompressEncoder encoder = (VelocityCompressEncoder)channelHandler;
                    ctx.pipeline().replace((ChannelHandler)encoder, "velocity-compressor", (ChannelHandler)new VelocityCompressEncoder(compressor));
                } else {
                    ctx.pipeline().addAfter("ws-encoder", "velocity-compressor", (ChannelHandler)new VelocityCompressEncoder(compressor));
                }
                if (!OnlineEmotesConfig.debug()) break;
                FancyToast.sendMessage((class_2561)class_2561.method_43469((String)"online_emotes.messages.compressionset", (Object[])new Object[]{compressionLevel}));
                break;
            }
            case 2: {
                PingWebSocketFrame frame = (PingWebSocketFrame)webSocketFrame2;
                frame.content().retain();
                ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content()), ctx.channel().voidPromise());
                break;
            }
            case 3: {
                CloseWebSocketFrame ignored = (CloseWebSocketFrame)webSocketFrame2;
                ctx.channel().close();
                break;
            }
            default: {
                OnlineEmotes.LOGGER.error("Unsupported frame type: {}!", (Object)msg.getClass().getName());
            }
        }
    }

    static {
        OnlineEmotes.LOGGER.info("Compression will use {}", (Object)Natives.compress.getLoadedVariant());
    }
}

