/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.utils;

import com.mojang.authlib.GameProfile;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8702;
import net.minecraft.class_9135;
import org.jetbrains.annotations.Nullable;

public class EmotePacketWrapper {
    public final byte[] emotePacket;
    public GameProfile gameProfile;
    @Nullable
    public UUID playerWorldId;
    @Nullable
    public String serverAddress;

    public EmotePacketWrapper(EmotePacket packet) throws IOException {
        this(INetworkInstance.safeGetBytesFromBuffer((ByteBuffer)packet.write()));
    }

    public EmotePacketWrapper(byte[] emotePacket) {
        this.emotePacket = emotePacket;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            this.gameProfile = player.method_7334();
            this.playerWorldId = player.method_5667();
            class_2535 connection = player.field_3944.method_48296();
            if (!connection.method_10756()) {
                this.serverAddress = EmotePacketWrapper.getIP(connection.method_10755());
            }
        }
    }

    public WebSocketFrame toWebSocketFrame() {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeByte(0);
        class_9135.field_49679.encode((Object)byteBuf, (Object)this.gameProfile);
        class_2540.method_56892((ByteBuf)byteBuf, (Object)this.playerWorldId, class_2540::method_56337);
        class_2540.method_56892((ByteBuf)byteBuf, (Object)this.serverAddress, (buf, address) -> class_8702.method_53013((ByteBuf)buf, (CharSequence)address, (int)address.length()));
        class_2540.method_56894((ByteBuf)byteBuf, (byte[])this.emotePacket);
        return new BinaryWebSocketFrame(byteBuf);
    }

    private static String getIP(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            return inetSocketAddress.getAddress().getHostAddress();
        }
        return address.toString();
    }
}

