/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.netty.compression;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.List;
import net.minecraft.class_8703;

public class VelocityCompressDecoder
extends MessageToMessageDecoder<WebSocketFrame> {
    public static final String NAME = "velocity-decompressor";
    private final VelocityCompressor compressor;

    public VelocityCompressDecoder(VelocityCompressor compressor) {
        this.compressor = compressor;
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame in, List<Object> out) throws Exception {
        if (in.content().readableBytes() == 0) {
            out.add(in.retain());
            return;
        }
        int claimedUncompressedSize = class_8703.method_53016((ByteBuf)in.content());
        if (claimedUncompressedSize == 0) {
            out.add(in.retain());
            return;
        }
        ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (ByteBuf)in.content());
        ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)claimedUncompressedSize);
        try {
            this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
            out.add(in.replace(uncompressed));
        }
        catch (Exception e) {
            uncompressed.release();
            throw e;
        }
        finally {
            compatibleIn.release();
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.compressor.close();
    }
}

