/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.redlance.dima_dencep.mods.online_emotes.OnlineEmotes;

public class FancyToast
implements Toast {
    public static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"online-emotes", (String)"icon.png");
    public static final Component TITLE = Component.translatable((String)"online_emotes.configuration.title");
    protected final Component title;
    private final List<FormattedCharSequence> messageLines = new ArrayList<FormattedCharSequence>();
    private Toast.Visibility visibility = Toast.Visibility.SHOW;

    protected FancyToast(Component title, List<FormattedCharSequence> msg) {
        this.title = title;
        this.messageLines.addAll(msg);
    }

    @NotNull
    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    public void update(ToastManager manager, long timeSinceLastVisible) {
        this.visibility = (double)timeSinceLastVisible < 1500.0 * manager.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public void render(GuiGraphics guiGraphics, Font textRenderer, long timeSinceLastVisible) {
        guiGraphics.fill(0, 0, this.width(), this.height() - 1, -1207959552);
        guiGraphics.fill(0, this.height() - 1, this.width(), this.height(), -255417);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ICON, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        if (this.title != null) {
            guiGraphics.drawString(textRenderer, this.title, 30, 7, -1, false);
        }
        for (int j = 0; j < this.messageLines.size(); ++j) {
            guiGraphics.drawString(textRenderer, this.messageLines.get(j), 30, (this.title != null ? 18 : 16) + j * 12, -1, false);
        }
    }

    public int width() {
        Font font = Minecraft.getInstance().font;
        int headerSize = font.width((FormattedText)this.title);
        int messageSize = this.messageLines.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(200);
        return 37 + Math.max(headerSize, messageSize);
    }

    public int height() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public int occcupiedSlotCount() {
        return Math.min(super.occcupiedSlotCount(), 5);
    }

    public static void sendMessage(Component description) {
        FancyToast.sendMessage(TITLE, description);
    }

    public static void sendMessage(Component title, Component description) {
        OnlineEmotes.LOGGER.info("Toast message: {}", (Object)description.getString());
        Minecraft.getInstance().getToastManager().addToast((Toast)new FancyToast(title, Minecraft.getInstance().font.split((FormattedText)description, 200)));
    }
}

