/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.utils;

import com.mojang.authlib.GameProfile;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.codec.ByteBufCodecs;
import org.jetbrains.annotations.Nullable;

public class EmotePacketWrapper {
    public final EmotePacket emotePacket;
    public final GameProfile gameProfile;
    @Nullable
    public UUID playerWorldId;
    @Nullable
    public String serverAddress;

    public EmotePacketWrapper(EmotePacket emotePacket) {
        this.emotePacket = emotePacket;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            this.gameProfile = player.getGameProfile();
            this.playerWorldId = player.getUUID();
            Connection connection = player.connection.getConnection();
            if (!connection.isMemoryConnection()) {
                this.serverAddress = EmotePacketWrapper.getIP(connection.getRemoteAddress());
            }
        } else {
            this.gameProfile = Minecraft.getInstance().getGameProfile();
        }
    }

    public WebSocketFrame toWebSocketFrame(ByteBufAllocator alloc) {
        ByteBuf byteBuf = alloc.buffer();
        byteBuf.writeByte(1);
        ByteBufCodecs.GAME_PROFILE.encode((Object)byteBuf, (Object)this.gameProfile);
        FriendlyByteBuf.writeNullable((ByteBuf)byteBuf, (Object)this.playerWorldId, FriendlyByteBuf::writeUUID);
        FriendlyByteBuf.writeNullable((ByteBuf)byteBuf, (Object)this.serverAddress, (buf, address) -> Utf8String.write((ByteBuf)buf, (CharSequence)address, (int)Short.MAX_VALUE));
        this.emotePacket.write(byteBuf, alloc);
        return new BinaryWebSocketFrame(byteBuf);
    }

    private static String getIP(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            return inetSocketAddress.getAddress().getHostAddress();
        }
        return address.toString();
    }
}

