/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.zusz.zcoffeecraft2.block.entity.ModBlockEntities;
import org.jetbrains.annotations.NotNull;

public class CoffeeCupBlockEntity
extends BlockEntity {
    public final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            CoffeeCupBlockEntity.this.setChanged();
            if (!CoffeeCupBlockEntity.this.level.isClientSide()) {
                CoffeeCupBlockEntity.this.level.sendBlockUpdated(CoffeeCupBlockEntity.this.getBlockPos(), CoffeeCupBlockEntity.this.getBlockState(), CoffeeCupBlockEntity.this.getBlockState(), 4);
            }
        }
    };
    private ItemStack coffeeStack = ItemStack.EMPTY;

    public CoffeeCupBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.COFFEE_CUP_BE.get(), pos, state);
    }

    public void setCoffeeStack(@NotNull ItemStack stack) {
        this.coffeeStack = stack.copy();
        this.itemHandler.setStackInSlot(0, this.coffeeStack);
        this.setChanged();
    }

    public ItemStack getCoffeeStack() {
        return this.coffeeStack;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        super.saveAdditional(pTag, pRegistries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void decreaseCoffeeStack(int i) {
        this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)this.itemHandler.getStackInSlot(0).getItem(), this.itemHandler.getStackInSlot(0).getCount() - 1));
        this.coffeeStack = this.itemHandler.getStackInSlot(0);
    }
}

