/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.zusz.zcoffeecraft2.component.ModDataComponents;
import net.zusz.zcoffeecraft2.item.ModItems;

public class CoffeeMachineMethods {
    public static boolean isIngredientValid(Item ingredient, String inputType) {
        ArrayList<Item> validIngredients = new ArrayList<Item>(List.of());
        if (inputType == "ingredient") {
            validIngredients.add(ModItems.WHIPPED_CREAM.asItem());
            validIngredients.add(ModItems.MILK_FOAM.asItem());
            validIngredients.add(ModItems.STEAMED_MILK.asItem());
            validIngredients.add(Items.MILK_BUCKET.asItem());
            validIngredients.add(Items.SUGAR.asItem());
            validIngredients.add(Items.HONEY_BOTTLE.asItem());
            validIngredients.add(Items.COCOA_BEANS.asItem());
        } else if (inputType == "input") {
            validIngredients.add((Item)ModItems.LIGHT_ARABICA_GROUND_COFFEE.get());
            validIngredients.add((Item)ModItems.MEDIUM_ARABICA_GROUND_COFFEE.get());
            validIngredients.add((Item)ModItems.DARK_ARABICA_GROUND_COFFEE.get());
            validIngredients.add((Item)ModItems.LIGHT_ROBUSTA_GROUND_COFFEE.get());
            validIngredients.add((Item)ModItems.MEDIUM_ROBUSTA_GROUND_COFFEE.get());
            validIngredients.add((Item)ModItems.DARK_ROBUSTA_GROUND_COFFEE.get());
        }
        return validIngredients.contains(ingredient);
    }

    public static List<String> addToIngredientsList(List<String> ingredients, Item item) {
        if (item == Items.SUGAR) {
            ingredients.add("sugar");
        } else if (item == Items.HONEY_BOTTLE) {
            ingredients.add("honey");
        } else if (item == Items.MILK_BUCKET) {
            ingredients.add("milk");
        } else if (item == Items.COCOA_BEANS) {
            ingredients.add("chocolate");
        } else if (item == ModItems.WHIPPED_CREAM.asItem()) {
            ingredients.add("whipped_cream");
        } else if (item == ModItems.MILK_FOAM.asItem()) {
            ingredients.add("milk_foam");
        } else if (item == ModItems.STEAMED_MILK.asItem()) {
            ingredients.add("steamed_milk");
        }
        return ingredients;
    }

    public static ItemStack addBeanAndRoastToOutput(ItemStack output, Item bean) {
        if (bean == ModItems.LIGHT_ARABICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"light");
            output.set(ModDataComponents.BEAN, (Object)"arabica");
        } else if (bean == ModItems.MEDIUM_ARABICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"medium");
            output.set(ModDataComponents.BEAN, (Object)"arabica");
        } else if (bean == ModItems.DARK_ARABICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"dark");
            output.set(ModDataComponents.BEAN, (Object)"arabica");
        } else if (bean == ModItems.LIGHT_ROBUSTA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"light");
            output.set(ModDataComponents.BEAN, (Object)"robusta");
        } else if (bean == ModItems.MEDIUM_ROBUSTA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"medium");
            output.set(ModDataComponents.BEAN, (Object)"robusta");
        } else if (bean == ModItems.DARK_ROBUSTA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"dark");
            output.set(ModDataComponents.BEAN, (Object)"robusta");
        } else if (bean == ModItems.LIGHT_LIBERICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"light");
            output.set(ModDataComponents.BEAN, (Object)"liberica");
        } else if (bean == ModItems.MEDIUM_LIBERICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"medium");
            output.set(ModDataComponents.BEAN, (Object)"liberica");
        } else if (bean == ModItems.DARK_LIBERICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"dark");
            output.set(ModDataComponents.BEAN, (Object)"liberica");
        } else {
            output = null;
        }
        return output;
    }

    public static ItemStack setOutputItemBasedOnContainer(Item containter) {
        ItemStack output = null;
        if (containter == ModItems.COFFEE_CUP.get()) {
            output = new ItemStack((ItemLike)ModItems.CUP_OF_COFFEE.get(), 1);
        }
        return output;
    }

    public static ItemStack getOutput(Item input, Item container, Item fluidInputItem, Item ingredient1, Item ingredient2, Item ingredient3, Item ingredient4) {
        ItemStack output = CoffeeMachineMethods.setOutputItemBasedOnContainer(container);
        if (output != null) {
            output = CoffeeMachineMethods.addBeanAndRoastToOutput(output, input);
            List<String> ingredients = new ArrayList<String>(List.of());
            ingredients = CoffeeMachineMethods.addToIngredientsList(ingredients, ingredient1);
            ingredients = CoffeeMachineMethods.addToIngredientsList(ingredients, ingredient2);
            ingredients = CoffeeMachineMethods.addToIngredientsList(ingredients, ingredient3);
            ingredients = CoffeeMachineMethods.addToIngredientsList(ingredients, ingredient4);
            if (output != null) {
                output.set(ModDataComponents.INGREDIENTS, ingredients);
            }
        }
        return output;
    }

    public static boolean isValidCoffeeCombination(ItemStack output) {
        List ingredients = (List)output.get(ModDataComponents.INGREDIENTS);
        return ingredients.isEmpty() || ingredients.size() == 1 && ingredients.contains("sugar") || ingredients.size() == 1 && ingredients.contains("milk_foam") || ingredients.size() == 2 && ingredients.contains("milk_foam") && ingredients.contains("sugar") || ingredients.size() == 1 && ingredients.contains("whipped_cream") || ingredients.size() == 2 && ingredients.contains("whipped_cream") && ingredients.contains("sugar") || ingredients.size() == 1 && ingredients.contains("steamed_milk") || ingredients.size() == 2 && ingredients.contains("steamed_milk") && ingredients.contains("sugar") || ingredients.size() == 2 && ingredients.contains("steamed_milk") && ingredients.contains("milk_foam") || ingredients.size() == 3 && ingredients.contains("steamed_milk") && ingredients.contains("milk_foam") && ingredients.contains("sugar") || ingredients.size() == 2 && ingredients.contains("honey") && ingredients.contains("milk_foam") || ingredients.size() == 3 && ingredients.contains("honey") && ingredients.contains("milk_foam") && ingredients.contains("sugar") || ingredients.size() == 3 && ingredients.contains("chocolate") && ingredients.contains("steamed_milk") && ingredients.contains("whipped_cream") || ingredients.size() == 4 && ingredients.contains("chocolate") && ingredients.contains("steamed_milk") && ingredients.contains("whipped_cream") && ingredients.contains("sugar");
    }
}

