/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.compat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import net.zusz.zcoffeecraft2.compat.CoffeeMachineRecipe;
import net.zusz.zcoffeecraft2.component.ModDataComponents;
import net.zusz.zcoffeecraft2.item.ModItems;

public class CoffeeMachineRecipeManager {
    public static List<CoffeeMachineRecipe> getAllRecipes() {
        ItemStack waterBottleStack = new ItemStack((ItemLike)Items.POTION);
        waterBottleStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        Ingredient water = Ingredient.of((ItemStack[])new ItemStack[]{waterBottleStack, new ItemStack((ItemLike)Items.WATER_BUCKET)});
        Ingredient water_output = Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE, Items.BUCKET});
        ArrayList<CoffeeMachineRecipe> CoffeeMachineRecipes = new ArrayList<CoffeeMachineRecipe>();
        ArrayList<DeferredItem<Item>> groundCoffees = new ArrayList<DeferredItem<Item>>(List.of(ModItems.LIGHT_ARABICA_GROUND_COFFEE, ModItems.MEDIUM_ARABICA_GROUND_COFFEE, ModItems.DARK_ARABICA_GROUND_COFFEE, ModItems.LIGHT_ROBUSTA_GROUND_COFFEE, ModItems.MEDIUM_ROBUSTA_GROUND_COFFEE, ModItems.DARK_ROBUSTA_GROUND_COFFEE, ModItems.LIGHT_LIBERICA_GROUND_COFFEE, ModItems.MEDIUM_LIBERICA_GROUND_COFFEE, ModItems.DARK_LIBERICA_GROUND_COFFEE));
        ArrayList<DeferredItem<Item>> containers = new ArrayList<DeferredItem<Item>>(List.of(ModItems.COFFEE_CUP));
        ArrayList<Ingredient> fluidItems = new ArrayList<Ingredient>(List.of(water));
        ArrayList<List> ingredientSets = new ArrayList<List>(List.of(List.of(), List.of(Items.SUGAR), List.of(ModItems.WHIPPED_CREAM), List.of(ModItems.WHIPPED_CREAM, Items.SUGAR), List.of(ModItems.MILK_FOAM), List.of(ModItems.MILK_FOAM, Items.SUGAR), List.of(ModItems.STEAMED_MILK), List.of(ModItems.STEAMED_MILK, Items.SUGAR), List.of(ModItems.STEAMED_MILK, ModItems.MILK_FOAM), List.of(ModItems.STEAMED_MILK, ModItems.MILK_FOAM, Items.SUGAR), List.of(Items.HONEY_BOTTLE, ModItems.MILK_FOAM), List.of(Items.HONEY_BOTTLE, ModItems.MILK_FOAM, Items.SUGAR), List.of(Items.COCOA_BEANS, ModItems.STEAMED_MILK, ModItems.WHIPPED_CREAM), List.of(Items.COCOA_BEANS, ModItems.STEAMED_MILK, ModItems.WHIPPED_CREAM, Items.SUGAR), List.of(Items.COCOA_BEANS, ModItems.MILK_FOAM), List.of(Items.COCOA_BEANS, ModItems.MILK_FOAM, Items.SUGAR)));
        for (ItemLike itemLike : groundCoffees) {
            for (ItemLike itemLike2 : containers) {
                for (Ingredient fluidItem : fluidItems) {
                    for (List ingredients : ingredientSets) {
                        Ingredient ingredient1 = ingredients.size() > 0 ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredients.get(0)}) : Ingredient.EMPTY;
                        Ingredient ingredient2 = ingredients.size() > 1 ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredients.get(1)}) : Ingredient.EMPTY;
                        Ingredient ingredient3 = ingredients.size() > 2 ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredients.get(2)}) : Ingredient.EMPTY;
                        Ingredient ingredient4 = ingredients.size() > 3 ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredients.get(3)}) : Ingredient.EMPTY;
                        Item ing1 = ingredients.size() > 0 ? ((ItemLike)ingredients.get(0)).asItem() : null;
                        Item ing2 = ingredients.size() > 1 ? ((ItemLike)ingredients.get(1)).asItem() : null;
                        Item ing3 = ingredients.size() > 2 ? ((ItemLike)ingredients.get(2)).asItem() : null;
                        Item ing4 = ingredients.size() > 3 ? ((ItemLike)ingredients.get(3)).asItem() : null;
                        Ingredient fluidOutput = Ingredient.EMPTY;
                        if (fluidItem == water) {
                            fluidOutput = water_output;
                        }
                        CoffeeMachineRecipes.add(new CoffeeMachineRecipe(Ingredient.of((ItemLike[])new ItemLike[]{itemLike}), Ingredient.of((ItemLike[])new ItemLike[]{itemLike2}), fluidItem, ingredient1, ingredient2, ingredient3, ingredient4, CoffeeMachineRecipeManager.getResult(itemLike.asItem(), itemLike2.asItem(), null, ing1, ing2, ing3, ing4), fluidOutput));
                    }
                }
            }
        }
        return CoffeeMachineRecipes;
    }

    public static ItemStack getResult(Item input, Item container, Item fluidInputItem, Item ingredient1, Item ingredient2, Item ingredient3, Item ingredient4) {
        ItemStack output = CoffeeMachineRecipeManager.setOutputItemBasedOnContainer(container);
        output = CoffeeMachineRecipeManager.addBeanAndRoastToOutput(output, input);
        List<String> ingredients = new ArrayList<String>(List.of());
        ingredients = CoffeeMachineRecipeManager.addToIngredientsList(ingredients, ingredient1);
        ingredients = CoffeeMachineRecipeManager.addToIngredientsList(ingredients, ingredient2);
        ingredients = CoffeeMachineRecipeManager.addToIngredientsList(ingredients, ingredient3);
        ingredients = CoffeeMachineRecipeManager.addToIngredientsList(ingredients, ingredient4);
        output.set(ModDataComponents.INGREDIENTS, ingredients);
        return output;
    }

    public static List<String> addToIngredientsList(List<String> ingredients, Item item) {
        if (item == Items.SUGAR) {
            ingredients.add("sugar");
        } else if (item == Items.HONEY_BOTTLE) {
            ingredients.add("honey");
        } else if (item == Items.MILK_BUCKET) {
            ingredients.add("milk");
        } else if (item == Items.COCOA_BEANS) {
            ingredients.add("chocolate");
        } else if (item == ModItems.WHIPPED_CREAM.asItem()) {
            ingredients.add("whipped_cream");
        } else if (item == ModItems.MILK_FOAM.asItem()) {
            ingredients.add("milk_foam");
        } else if (item == ModItems.STEAMED_MILK.asItem()) {
            ingredients.add("steamed_milk");
        }
        return ingredients;
    }

    public static ItemStack addBeanAndRoastToOutput(ItemStack output, Item bean) {
        if (bean == ModItems.LIGHT_ARABICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"light");
            output.set(ModDataComponents.BEAN, (Object)"arabica");
        } else if (bean == ModItems.MEDIUM_ARABICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"medium");
            output.set(ModDataComponents.BEAN, (Object)"arabica");
        } else if (bean == ModItems.DARK_ARABICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"dark");
            output.set(ModDataComponents.BEAN, (Object)"arabica");
        } else if (bean == ModItems.LIGHT_ROBUSTA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"light");
            output.set(ModDataComponents.BEAN, (Object)"robusta");
        } else if (bean == ModItems.MEDIUM_ROBUSTA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"medium");
            output.set(ModDataComponents.BEAN, (Object)"robusta");
        } else if (bean == ModItems.DARK_ROBUSTA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"dark");
            output.set(ModDataComponents.BEAN, (Object)"robusta");
        } else if (bean == ModItems.LIGHT_LIBERICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"light");
            output.set(ModDataComponents.BEAN, (Object)"liberica");
        } else if (bean == ModItems.MEDIUM_LIBERICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"medium");
            output.set(ModDataComponents.BEAN, (Object)"liberica");
        } else if (bean == ModItems.DARK_LIBERICA_GROUND_COFFEE.get()) {
            output.set(ModDataComponents.ROAST, (Object)"dark");
            output.set(ModDataComponents.BEAN, (Object)"liberica");
        }
        return output;
    }

    public static ItemStack setOutputItemBasedOnContainer(Item containter) {
        ItemStack output = null;
        if (containter == ModItems.COFFEE_CUP.get()) {
            output = new ItemStack((ItemLike)ModItems.CUP_OF_COFFEE.get(), 1);
        }
        return output;
    }
}

