/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.datagen;

import java.util.function.Function;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.zusz.zcoffeecraft2.block.ModBlocks;
import net.zusz.zcoffeecraft2.block.custom.ArabicaCoffeeBushBlock;
import net.zusz.zcoffeecraft2.block.custom.LibericaCoffeeBushBlock;
import net.zusz.zcoffeecraft2.block.custom.RobustaCoffeeBushBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, "zcoffeecraft2", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.coffeeBeanSack(ModBlocks.RAW_ARABICA_COFFEE_BEAN_SACK, "raw_arabica_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.LIGHT_ROASTED_ARABICA_COFFEE_BEAN_SACK, "light_roasted_arabica_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.MEDIUM_ROASTED_ARABICA_COFFEE_BEAN_SACK, "medium_roasted_arabica_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.DARK_ROASTED_ARABICA_COFFEE_BEAN_SACK, "dark_roasted_arabica_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.RAW_ROBUSTA_COFFEE_BEAN_SACK, "raw_robusta_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.LIGHT_ROASTED_ROBUSTA_COFFEE_BEAN_SACK, "light_roasted_robusta_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.MEDIUM_ROASTED_ROBUSTA_COFFEE_BEAN_SACK, "medium_roasted_robusta_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.DARK_ROASTED_ROBUSTA_COFFEE_BEAN_SACK, "dark_roasted_robusta_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.RAW_LIBERICA_COFFEE_BEAN_SACK, "raw_liberica_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.LIGHT_ROASTED_LIBERICA_COFFEE_BEAN_SACK, "light_roasted_liberica_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.MEDIUM_ROASTED_LIBERICA_COFFEE_BEAN_SACK, "medium_roasted_liberica_coffee_bean_sack_top");
        this.coffeeBeanSack(ModBlocks.DARK_ROASTED_LIBERICA_COFFEE_BEAN_SACK, "dark_roasted_liberica_coffee_bean_sack_top");
        this.makeBush((BushBlock)ModBlocks.ARABICA_COFFEE_BUSH.get(), ArabicaCoffeeBushBlock.AGE, "arabica_coffee_bush_stage", "arabica_coffee_bush_stage");
        this.makeBush((BushBlock)ModBlocks.ROBUSTA_COFFEE_BUSH.get(), RobustaCoffeeBushBlock.AGE, "robusta_coffee_bush_stage", "robusta_coffee_bush_stage");
        this.makeBush((BushBlock)ModBlocks.LIBERICA_COFFEE_BUSH.get(), LibericaCoffeeBushBlock.AGE, "liberica_coffee_bush_stage", "liberica_coffee_bush_stage");
    }

    public void makeBush(BushBlock block, IntegerProperty ageProperty, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.states((BlockState)state, ageProperty, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] states(BlockState state, IntegerProperty ageProperty, String modelName, String textureName) {
        int age = (Integer)state.getValue((Property)ageProperty);
        return new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cross(modelName + age, this.modLoc("block/" + textureName + age))).renderType("cutout"))};
    }

    private void cubeAllBlockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void cubeBottomTopBlockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), (ModelFile)this.models().cubeBottomTop(this.name(deferredBlock), this.blockTexture(deferredBlock, "_side"), this.blockTexture(deferredBlock, "_bottom"), this.blockTexture(deferredBlock, "_top")));
    }

    private void coffeeBeanSack(DeferredBlock<?> deferredBlock, String topTextureName) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), (ModelFile)this.models().cubeBottomTop(this.name(deferredBlock), this.modLoc("block/coffee_bean_sack_side"), this.modLoc("block/coffee_bean_sack_bottom"), this.modLoc("block/" + topTextureName)));
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private String name(DeferredBlock<?> block) {
        return block.getId().getPath();
    }

    private ResourceLocation blockTexture(DeferredBlock<?> block, String suffix) {
        return this.modLoc("block/" + this.name(block) + suffix);
    }
}

