/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.effect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.zusz.zcoffeecraft2.effect.CoffeeEffectInstance;

public class CoffeeEffectData {
    private static final Map<UUID, List<CoffeeEffectInstance>> queuedEffects = new HashMap<UUID, List<CoffeeEffectInstance>>();

    public static void addEffect(ServerPlayer player, CoffeeEffectInstance instance) {
        queuedEffects.computeIfAbsent(player.getUUID(), uuid -> new ArrayList()).add(instance);
    }

    public static void tick(ServerLevel level) {
        Registry mobEffectRegistry = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT);
        for (ServerPlayer player : level.players()) {
            List<CoffeeEffectInstance> queue = queuedEffects.get(player.getUUID());
            if (queue == null || queue.isEmpty()) continue;
            Iterator<CoffeeEffectInstance> iterator = queue.iterator();
            while (iterator.hasNext()) {
                CoffeeEffectInstance effect = iterator.next();
                --effect.ticksUntilApply;
                if (effect.ticksUntilApply > 0) continue;
                if (effect.effect != null) {
                    Optional keyOpt = mobEffectRegistry.getResourceKey((Object)effect.effect);
                    if (keyOpt.isEmpty()) {
                        throw new IllegalStateException("Effect not registered: " + String.valueOf(effect.effect));
                    }
                    ResourceKey effectKey = (ResourceKey)keyOpt.get();
                    Holder effectHolder = (Holder)mobEffectRegistry.getHolder(effectKey).orElseThrow(() -> new IllegalStateException("Holder not found for effect key: " + String.valueOf(effectKey)));
                    player.addEffect(new MobEffectInstance(effectHolder, effect.duration, effect.amplifier));
                }
                if (effect.secondaryEffect != null && effect.secondaryEffectDuration > 0) {
                    player.addEffect(new MobEffectInstance(effect.secondaryEffect, effect.secondaryEffectDuration, effect.secondaryEffectAmplifier));
                }
                iterator.remove();
            }
            if (!queue.isEmpty()) continue;
            queuedEffects.remove(player.getUUID());
        }
    }
}

