/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.event;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.zusz.zcoffeecraft2.effect.CoffeeEffectData;
import net.zusz.zcoffeecraft2.item.ModItems;
import net.zusz.zcoffeecraft2.screen.custom.CoffeeMachineScreen;

@EventBusSubscriber(modid="zcoffeecraft2", bus=EventBusSubscriber.Bus.GAME)
public class ModEvents {
    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        for (ServerLevel level : event.getServer().getAllLevels()) {
            CoffeeEffectData.tick(level);
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof CoffeeMachineScreen)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        ItemStack waterBottleStack = new ItemStack((ItemLike)Items.POTION);
        waterBottleStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        List<Item> usedToMakeCoffee = List.of(ModItems.LIGHT_ARABICA_GROUND_COFFEE.asItem(), ModItems.MEDIUM_ARABICA_GROUND_COFFEE.asItem(), ModItems.DARK_ARABICA_GROUND_COFFEE.asItem(), ModItems.LIGHT_ROBUSTA_GROUND_COFFEE.asItem(), ModItems.MEDIUM_ROBUSTA_GROUND_COFFEE.asItem(), ModItems.DARK_ROBUSTA_GROUND_COFFEE.asItem(), ModItems.LIGHT_LIBERICA_GROUND_COFFEE.asItem(), ModItems.MEDIUM_LIBERICA_GROUND_COFFEE.asItem(), ModItems.DARK_LIBERICA_GROUND_COFFEE.asItem(), ModItems.MILK_FOAM.asItem(), ModItems.WHIPPED_CREAM.asItem(), ModItems.STEAMED_MILK.asItem(), Items.HONEY_BOTTLE.asItem(), Items.COCOA_BEANS.asItem());
        if (stack.getItem() == Items.WATER_BUCKET) {
            List tooltip = event.getToolTip();
            tooltip.add(Component.literal((String)"\u2615Every type of Coffee needs Water!\u2615").withStyle(ChatFormatting.GOLD));
        } else if (stack.getItem() == waterBottleStack.getItem()) {
            List tooltip = event.getToolTip();
            tooltip.add(Component.literal((String)"\u2615Every type of Coffee needs Water!\u2615").withStyle(ChatFormatting.GOLD));
        } else if (stack.getItem() == ModItems.COFFEE_CUP.asItem()) {
            List tooltip = event.getToolTip();
            tooltip.add(Component.literal((String)"\u2615A Cup to put your Coffee into!\u2615").withStyle(ChatFormatting.GOLD));
        } else if (usedToMakeCoffee.contains(stack.getItem())) {
            List tooltip = event.getToolTip();
            tooltip.add(Component.literal((String)"\u2615This item can be used to make coffee!\u2615").withStyle(ChatFormatting.GOLD));
        }
    }
}

