/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.item.custom;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.zusz.zcoffeecraft2.block.ModBlocks;
import net.zusz.zcoffeecraft2.block.custom.CoffeeCupBlock;
import net.zusz.zcoffeecraft2.block.custom.enums.RoastType;
import net.zusz.zcoffeecraft2.block.entity.CoffeeCupBlockEntity;
import net.zusz.zcoffeecraft2.component.ModDataComponents;
import net.zusz.zcoffeecraft2.effect.CoffeeEffectData;
import net.zusz.zcoffeecraft2.effect.CoffeeEffectInstance;
import net.zusz.zcoffeecraft2.effect.ModEffects;
import net.zusz.zcoffeecraft2.item.ModItems;
import net.zusz.zcoffeecraft2.screen.custom.CoffeeMachineScreen;
import org.jetbrains.annotations.NotNull;

public class CoffeeItem
extends Item {
    public CoffeeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, @NotNull LivingEntity entity) {
        ServerPlayer player;
        List ingredients = (List)stack.get(ModDataComponents.INGREDIENTS);
        Holder<MobEffect> effect = this.getEffect(ingredients);
        int duration = this.getDuration((String)stack.get(ModDataComponents.BEAN), (String)stack.get(ModDataComponents.ROAST), ingredients);
        int amplifier = this.getAmplifier((String)stack.get(ModDataComponents.BEAN));
        int delay = this.getDelay((String)stack.get(ModDataComponents.ROAST));
        Holder<MobEffect> secondaryEffect = this.getSecodaryEffect((String)stack.get(ModDataComponents.BEAN), ingredients);
        int secondaryEffectDuration = 0;
        if (secondaryEffect != null) {
            secondaryEffectDuration = this.getSecodaryEffectDuration((MobEffect)secondaryEffect.value(), ingredients);
        }
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            if (effect != null) {
                CoffeeEffectInstance ceffect = new CoffeeEffectInstance((MobEffect)effect.value(), duration, amplifier, delay, secondaryEffect, secondaryEffectDuration, 0);
                CoffeeEffectData.addEffect(player, ceffect);
                if (delay != 0) {
                    player.addEffect(new MobEffectInstance(ModEffects.CAFFEINATED_EFFECT, delay, 0));
                }
            }
        }
        super.finishUsingItem(stack, level, entity);
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                ItemStack cupStack = new ItemStack((ItemLike)ModItems.COFFEE_CUP.asItem());
                if (stack.isEmpty()) {
                    return cupStack;
                }
                if (!player.getInventory().add(cupStack)) {
                    player.drop(cupStack, false);
                }
            }
        }
        System.out.println((String)stack.get(ModDataComponents.ROAST));
        System.out.println();
        return stack;
    }

    private Holder<MobEffect> getSecodaryEffect(String bean, List<String> ingredients) {
        if (Objects.equals(bean, "liberica")) {
            if (ingredients.size() == 0 || ingredients.size() == 1 && ingredients.contains("sugar")) {
                return MobEffects.JUMP;
            }
            return MobEffects.MOVEMENT_SPEED;
        }
        return null;
    }

    private int getSecodaryEffectDuration(MobEffect secondaryEffect, List<String> ingredients) {
        if (secondaryEffect == MobEffects.MOVEMENT_SPEED) {
            return 1200;
        }
        return 2400;
    }

    @NotNull
    public Component getName(ItemStack stack) {
        List ingredients = (List)stack.get(ModDataComponents.INGREDIENTS);
        String roast = (String)stack.get(ModDataComponents.ROAST);
        MutableComponent coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.notype");
        MutableComponent roastComponent = Component.translatable((String)"coffeeroast.zcoffeecraft2.noroast");
        Holder<MobEffect> effect = this.getEffect(ingredients);
        if (effect == MobEffects.MOVEMENT_SPEED) {
            coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.espresso");
        } else if (effect == MobEffects.JUMP) {
            coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.macchiato");
        } else if (effect == MobEffects.ABSORPTION) {
            coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.con_panna");
        } else if (effect == MobEffects.DAMAGE_RESISTANCE) {
            coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.flat_white");
        } else if (effect == MobEffects.REGENERATION) {
            coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.latte");
        } else if (effect == MobEffects.HEALTH_BOOST) {
            coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.honey_raf");
        } else if (effect == MobEffects.DAMAGE_BOOST) {
            coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.mocha");
        } else if (effect == MobEffects.NIGHT_VISION) {
            coffeeComponent = Component.translatable((String)"coffeetype.zcoffeecraft2.marocchino");
        }
        if (roast != null) {
            if (Objects.equals(roast, "light")) {
                roastComponent = Component.translatable((String)"coffeeroast.zcoffeecraft2.light");
            } else if (Objects.equals(roast, "medium")) {
                roastComponent = Component.translatable((String)"coffeeroast.zcoffeecraft2.medium");
            } else if (Objects.equals(roast, "dark")) {
                roastComponent = Component.translatable((String)"coffeeroast.zcoffeecraft2.dark");
            }
        }
        return Component.translatable((String)"coffeetype.zcoffeecraft2.base", (Object[])new Object[]{roastComponent, coffeeComponent});
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    private boolean isInJEIContext() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> element.getClassName().contains("mezz.jei"));
    }

    private int getDelay(String roast) {
        String string = roast;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"light", "medium", "dark"}, (Object)string, n)) {
            case 0 -> 0;
            case 1 -> 200;
            case 2 -> 500;
            case -1 -> 0;
            default -> throw new IllegalStateException("Unexpected value: " + roast);
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown() && Minecraft.getInstance().screen instanceof CoffeeMachineScreen || this.isInJEIContext()) {
            if (Screen.hasShiftDown() && Minecraft.getInstance().screen instanceof CoffeeMachineScreen || this.isInJEIContext()) {
                tooltipComponents.add((Component)Component.literal((String)"Beans:").withStyle(ChatFormatting.BLUE));
                if (stack.get(ModDataComponents.BEAN) == null) {
                    tooltipComponents.add((Component)Component.literal((String)"   -Depends on Bean type").withStyle(ChatFormatting.GRAY));
                } else if (Objects.equals(stack.get(ModDataComponents.BEAN), "arabica")) {
                    tooltipComponents.add((Component)Component.literal((String)"   -Arabica").withStyle(ChatFormatting.GRAY));
                } else if (Objects.equals(stack.get(ModDataComponents.BEAN), "robusta")) {
                    tooltipComponents.add((Component)Component.literal((String)"   -Robusta").withStyle(ChatFormatting.GRAY));
                } else if (Objects.equals(stack.get(ModDataComponents.BEAN), "liberica")) {
                    tooltipComponents.add((Component)Component.literal((String)"   -Liberica").withStyle(ChatFormatting.GRAY));
                }
                tooltipComponents.add((Component)Component.literal((String)"Roast:").withStyle(ChatFormatting.BLUE));
                if (stack.get(ModDataComponents.ROAST) == null) {
                    tooltipComponents.add((Component)Component.literal((String)"   -Depends on Bean roast").withStyle(ChatFormatting.GRAY));
                } else {
                    switch ((String)stack.get(ModDataComponents.ROAST)) {
                        case "light": {
                            tooltipComponents.add((Component)Component.literal((String)"   -Light").withStyle(ChatFormatting.GRAY));
                            break;
                        }
                        case "medium": {
                            tooltipComponents.add((Component)Component.literal((String)"   -Medium").withStyle(ChatFormatting.GRAY));
                            break;
                        }
                        case "dark": {
                            tooltipComponents.add((Component)Component.literal((String)"   -Dark").withStyle(ChatFormatting.GRAY));
                        }
                    }
                }
                if (stack.get(ModDataComponents.INGREDIENTS) != null && !((List)stack.get(ModDataComponents.INGREDIENTS)).isEmpty()) {
                    tooltipComponents.add((Component)Component.literal((String)"Ingredients:").withStyle(ChatFormatting.BLUE));
                    Object object = Objects.requireNonNull((List)stack.get(ModDataComponents.INGREDIENTS)).iterator();
                    while (object.hasNext()) {
                        String item;
                        switch (item = (String)object.next()) {
                            case "sugar": {
                                tooltipComponents.add((Component)Component.literal((String)"   -Sugar").withStyle(ChatFormatting.GRAY));
                                break;
                            }
                            case "milk": {
                                tooltipComponents.add((Component)Component.literal((String)"   -Milk").withStyle(ChatFormatting.GRAY));
                                break;
                            }
                            case "honey": {
                                tooltipComponents.add((Component)Component.literal((String)"   -Honey").withStyle(ChatFormatting.GRAY));
                                break;
                            }
                            case "chocolate": {
                                tooltipComponents.add((Component)Component.literal((String)"   -Chocolate").withStyle(ChatFormatting.GRAY));
                                break;
                            }
                            case "milk_foam": {
                                tooltipComponents.add((Component)Component.literal((String)"   -Milk Foam").withStyle(ChatFormatting.GRAY));
                                break;
                            }
                            case "steamed_milk": {
                                tooltipComponents.add((Component)Component.literal((String)"   -Steamed Milk").withStyle(ChatFormatting.GRAY));
                                break;
                            }
                            case "whipped_cream": {
                                tooltipComponents.add((Component)Component.literal((String)"   -Whipped Cream").withStyle(ChatFormatting.GRAY));
                            }
                        }
                    }
                }
            } else if (Minecraft.getInstance().screen instanceof CoffeeMachineScreen) {
                tooltipComponents.add((Component)Component.translatable((String)"\u00a77Hold \u00a7eShift\u00a77 for more Information"));
            }
        } else if (Minecraft.getInstance().screen instanceof CoffeeMachineScreen) {
            tooltipComponents.add((Component)Component.translatable((String)"\u00a77Hold \u00a7eShift\u00a77 for more Information"));
        }
        List ingredients = (List)stack.get(ModDataComponents.INGREDIENTS);
        Holder<MobEffect> effect = this.getEffect(ingredients);
        int duration = this.getDuration((String)stack.get(ModDataComponents.BEAN), (String)stack.get(ModDataComponents.ROAST), ingredients);
        int amplifier = this.getAmplifier((String)stack.get(ModDataComponents.BEAN));
        int delay = this.getDelay((String)stack.get(ModDataComponents.ROAST));
        Component effectName = this.getEffectNameComponent(effect);
        MutableComponent potency = amplifier != 0 ? Component.translatable((String)("potion.potency." + amplifier)) : (effect != null ? Component.literal((String)"I") : Component.literal((String)""));
        MutableComponent durationComponent = !this.getFormattedDuration(duration).isEmpty() ? Component.literal((String)(" (" + this.getFormattedDuration(duration) + ")")) : Component.literal((String)"");
        MutableComponent delayComponent = !this.getFormattedDuration(delay).isEmpty() ? Component.literal((String)(" [" + this.getFormattedDuration(delay) + "]")) : Component.literal((String)"");
        tooltipComponents.add((Component)Component.literal((String)"").append((Component)effectName.copy().withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)" ").withStyle(ChatFormatting.BLUE)).append((Component)potency.copy().withStyle(ChatFormatting.BLUE)).append((Component)durationComponent.copy().withStyle(ChatFormatting.BLUE)).append((Component)delayComponent.copy().withStyle(ChatFormatting.GOLD)));
        Holder<MobEffect> sEffect = this.getSecodaryEffect((String)stack.get(ModDataComponents.BEAN), ingredients);
        if (sEffect != null) {
            String sFormattedDuration = this.getFormattedDuration(this.getSecodaryEffectDuration((MobEffect)sEffect.value(), ingredients));
            MutableComponent sDurationComponent = !sFormattedDuration.isEmpty() ? Component.literal((String)(" (" + sFormattedDuration + ")")) : Component.literal((String)"");
            MutableComponent sPotency = Component.literal((String)"I");
            Component sEffectName = this.getEffectNameComponent(sEffect);
            tooltipComponents.add((Component)Component.literal((String)"").append((Component)sEffectName.copy().withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)" ").withStyle(ChatFormatting.BLUE)).append((Component)sPotency.copy().withStyle(ChatFormatting.BLUE)).append((Component)sDurationComponent.copy().withStyle(ChatFormatting.BLUE)).append((Component)delayComponent.copy().withStyle(ChatFormatting.GOLD)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private Component getEffectNameComponent(Holder<MobEffect> effect) {
        if (effect == null) {
            return Component.literal((String)"");
        }
        if (effect == MobEffects.MOVEMENT_SPEED) {
            return Component.translatable((String)"effect.minecraft.speed");
        }
        if (effect == MobEffects.JUMP) {
            return Component.translatable((String)"effect.minecraft.jump_boost");
        }
        if (effect == MobEffects.ABSORPTION) {
            return Component.translatable((String)"effect.minecraft.absorption");
        }
        if (effect == MobEffects.DAMAGE_RESISTANCE) {
            return Component.translatable((String)"effect.minecraft.resistance");
        }
        if (effect == MobEffects.REGENERATION) {
            return Component.translatable((String)"effect.minecraft.regeneration");
        }
        if (effect == MobEffects.HEALTH_BOOST) {
            return Component.translatable((String)"effect.minecraft.health_boost");
        }
        if (effect == MobEffects.DAMAGE_BOOST) {
            return Component.translatable((String)"effect.minecraft.strength");
        }
        if (effect == MobEffects.NIGHT_VISION) {
            return Component.translatable((String)"effect.minecraft.night_vision");
        }
        return Component.literal((String)"");
    }

    private Holder<MobEffect> getEffect(List<String> ingredients) {
        Holder effect = null;
        if (ingredients != null) {
            if (ingredients.size() == 0 || ingredients.size() == 1 && ingredients.contains("sugar")) {
                effect = MobEffects.MOVEMENT_SPEED;
            } else if (ingredients.size() == 1 && ingredients.contains("milk_foam") || ingredients.size() == 2 && ingredients.contains("milk_foam)") && ingredients.contains("sugar")) {
                effect = MobEffects.JUMP;
            } else if (ingredients.size() == 1 && ingredients.contains("whipped_cream") || ingredients.size() == 2 && ingredients.contains("whipped_cream") && ingredients.contains("sugar")) {
                effect = MobEffects.ABSORPTION;
            } else if (ingredients.size() == 1 && ingredients.contains("steamed_milk") || ingredients.size() == 2 && ingredients.contains("steamed_milk") && ingredients.contains("sugar")) {
                effect = MobEffects.DAMAGE_RESISTANCE;
            } else if (ingredients.size() == 2 && ingredients.contains("steamed_milk") && ingredients.contains("milk_foam") || ingredients.size() == 3 && ingredients.contains("steamed_milk") && ingredients.contains("milk_foam") && ingredients.contains("sugar")) {
                effect = MobEffects.REGENERATION;
            } else if (ingredients.size() == 2 && ingredients.contains("honey") && ingredients.contains("milk_foam") || ingredients.size() == 3 && ingredients.contains("honey") && ingredients.contains("milk_foam") && ingredients.contains("sugar")) {
                effect = MobEffects.HEALTH_BOOST;
            } else if (ingredients.size() == 3 && ingredients.contains("chocolate") && ingredients.contains("steamed_milk") && ingredients.contains("whipped_cream") || ingredients.size() == 4 && ingredients.contains("chocolate") && ingredients.contains("steamed_milk") && ingredients.contains("whipped_cream") && ingredients.contains("sugar")) {
                effect = MobEffects.DAMAGE_BOOST;
            } else if (ingredients.size() == 2 && ingredients.contains("chocolate") && ingredients.contains("milk_foam") || ingredients.size() == 3 && ingredients.contains("chocolate") && ingredients.contains("milk_foam") && ingredients.contains("sugar")) {
                effect = MobEffects.NIGHT_VISION;
            }
        }
        return effect;
    }

    private int getDuration(@Nullable String bean, @Nullable String roast, @Nullable List<String> ingredients) {
        int duration = 0;
        String string = bean;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"arabica", "robusta", "liberica"}, (Object)string, n)) {
            case 0: {
                duration = 4800;
                break;
            }
            case 1: {
                duration = 3000;
                break;
            }
            case 2: {
                duration = 2400;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + bean);
            }
        }
        string = roast;
        n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"light", "medium", "dark"}, (Object)string, n)) {
            case 0: {
                break;
            }
            case 1: {
                if (duration == 3000) {
                    duration = 4800;
                    break;
                }
                if (duration == 4800) {
                    duration = 6600;
                    break;
                }
                if (duration != 2400) break;
                duration = 3600;
                break;
            }
            case 2: {
                if (duration == 3000) {
                    duration = 5400;
                    break;
                }
                if (duration == 4800) {
                    duration = 7200;
                    break;
                }
                if (duration != 2400) break;
                duration = 4800;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + roast);
            }
        }
        if (ingredients != null && ingredients.contains("sugar")) {
            duration += 1200;
        }
        return duration;
    }

    private int getAmplifier(String bean) {
        int amplifier = 0;
        String string = bean;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"arabica", "robusta", "liberica"}, (Object)string, n)) {
            case 0: {
                amplifier = 0;
                break;
            }
            case 1: {
                amplifier = 1;
                break;
            }
            case 2: {
                amplifier = 0;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + bean);
            }
        }
        return amplifier;
    }

    private String getFormattedDuration(int duration) {
        if (duration >= 1) {
            int durationSeconds = duration / 20;
            int minutes = durationSeconds / 60;
            int seconds = durationSeconds % 60;
            String formattedDuration = String.format("%d:%02d", minutes, seconds);
            return formattedDuration;
        }
        return "";
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        ItemStack stack = context.getItemInHand();
        if (player == null || !player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        BlockPos placePos = clickedPos.relative(context.getClickedFace());
        BlockState existingState = level.getBlockState(placePos);
        if (!existingState.canBeReplaced()) {
            return InteractionResult.FAIL;
        }
        BlockState state = (BlockState)((Block)ModBlocks.COFFEE_CUP_BLOCK.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        String roast = (String)stack.get(ModDataComponents.ROAST);
        if (roast != null) {
            switch (roast) {
                case "medium": {
                    state = (BlockState)state.setValue(CoffeeCupBlock.ROAST, (Comparable)((Object)RoastType.MEDIUM));
                    break;
                }
                case "dark": {
                    state = (BlockState)state.setValue(CoffeeCupBlock.ROAST, (Comparable)((Object)RoastType.DARK));
                    break;
                }
                default: {
                    state = (BlockState)state.setValue(CoffeeCupBlock.ROAST, (Comparable)((Object)RoastType.LIGHT));
                }
            }
        }
        if (!level.isClientSide) {
            level.setBlock(placePos, state, 11);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        if ((blockEntity = level.getBlockEntity(placePos)) instanceof CoffeeCupBlockEntity) {
            CoffeeCupBlockEntity cupEntity = (CoffeeCupBlockEntity)blockEntity;
            ItemStack toSet = new ItemStack((ItemLike)stack.getItem());
            toSet.set(ModDataComponents.ROAST, (Object)((String)stack.get(ModDataComponents.ROAST)));
            toSet.set(ModDataComponents.BEAN, (Object)((String)stack.get(ModDataComponents.BEAN)));
            toSet.set(ModDataComponents.INGREDIENTS, (Object)((List)stack.get(ModDataComponents.INGREDIENTS)));
            cupEntity.setCoffeeStack(toSet);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

