/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.screen.custom;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.zusz.zcoffeecraft2.block.ModBlocks;
import net.zusz.zcoffeecraft2.block.entity.CoffeeMachineBlockEntity;
import net.zusz.zcoffeecraft2.item.ModItems;
import net.zusz.zcoffeecraft2.screen.ModMenuTypes;

public class CoffeeMachineMenu
extends AbstractContainerMenu {
    public final CoffeeMachineBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int INPUT_SLOT = 0;
    private static final int CONTAINER_SLOT = 1;
    private static final int FLUID_INPUT_SLOT = 2;
    private static final int INGREDIENT_SLOT_1 = 3;
    private static final int INGREDIENT_SLOT_2 = 4;
    private static final int INGREDIENT_SLOT_3 = 5;
    private static final int INGREDIENT_SLOT_4 = 6;
    private static final int OUTPUT_SLOT = 7;
    private static final int FLUID_CONTAINER_OUTPUT_SLOT = 8;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 9;

    public CoffeeMachineMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public CoffeeMachineMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.COFFEE_MACHINE_MENU.get(), pContainerId);
        this.blockEntity = (CoffeeMachineBlockEntity)entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 0, 75, 24));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 1, 75, 45));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 2, 14, 24));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 3, 34, 24));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 4, 34, 45));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 5, 54, 24));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 6, 54, 45));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 7, 124, 34));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 8, 14, 45));
        this.addDataSlots(data);
        System.out.println(this.blockEntity.itemHandler.getSlots());
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledArrowProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int arrowPixelSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * arrowPixelSize / maxProgress : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (this.isValidForInputSlot(sourceStack)) {
                if (!this.moveItemStackTo(sourceStack, 36, 37, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.isValidForContainerSlot(sourceStack)) {
                if (!this.moveItemStackTo(sourceStack, 37, 38, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.isValidForFluidInputSlot(sourceStack)) {
                if (!this.moveItemStackTo(sourceStack, 38, 39, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.isValidForIngredient(sourceStack)) return ItemStack.EMPTY;
                if (!this.moveItemStackTo(sourceStack, 39, 43, false)) {
                    return ItemStack.EMPTY;
                }
            }
        } else if (index < 45) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slot index: " + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.isEmpty()) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private boolean isValidForIngredient(ItemStack sourceStack) {
        ArrayList<Item> validItems = new ArrayList<Item>(List.of(ModItems.WHIPPED_CREAM.asItem(), ModItems.STEAMED_MILK.asItem(), ModItems.MILK_FOAM.asItem(), Items.SUGAR, Items.HONEY_BOTTLE, Items.COCOA_BEANS));
        return validItems.contains(sourceStack.getItem());
    }

    private boolean isValidForFluidInputSlot(ItemStack sourceStack) {
        ItemStack waterBottleStack = new ItemStack((ItemLike)Items.POTION);
        waterBottleStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        ArrayList<Item> validItems = new ArrayList<Item>(List.of(Items.WATER_BUCKET, waterBottleStack.getItem()));
        return validItems.contains(sourceStack.getItem());
    }

    private boolean isValidForContainerSlot(ItemStack sourceStack) {
        ArrayList<Item> validItems = new ArrayList<Item>(List.of(ModItems.COFFEE_CUP.asItem()));
        return validItems.contains(sourceStack.getItem());
    }

    private boolean isValidForInputSlot(ItemStack sourceStack) {
        ArrayList<Item> validItems = new ArrayList<Item>(List.of(ModItems.LIGHT_ARABICA_GROUND_COFFEE.asItem(), ModItems.MEDIUM_ARABICA_GROUND_COFFEE.asItem(), ModItems.DARK_ARABICA_GROUND_COFFEE.asItem(), ModItems.LIGHT_ROBUSTA_GROUND_COFFEE.asItem(), ModItems.MEDIUM_ROBUSTA_GROUND_COFFEE.asItem(), ModItems.DARK_ROBUSTA_GROUND_COFFEE.asItem(), ModItems.LIGHT_LIBERICA_GROUND_COFFEE.asItem(), ModItems.MEDIUM_LIBERICA_GROUND_COFFEE.asItem(), ModItems.DARK_LIBERICA_GROUND_COFFEE.asItem()));
        return validItems.contains(sourceStack.getItem());
    }

    public boolean stillValid(Player pPlayer) {
        return CoffeeMachineMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocks.COFFEE_MACHINE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStackHandler getItemHandler() {
        System.out.println(this.blockEntity.itemHandler.getSlots());
        return this.blockEntity.itemHandler;
    }
}

