/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.screen.custom;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.zusz.zcoffeecraft2.block.ModBlocks;
import net.zusz.zcoffeecraft2.item.ModItems;

public class GuideBookScreen
extends Screen {
    public int currentPage = 0;
    private final int maxPage = 7;
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"zcoffeecraft2", (String)"textures/gui/guidebook_bg.png");

    public GuideBookScreen() {
        super((Component)Component.translatable((String)"guide.zcoffeecraft2.title"));
    }

    protected void init() {
        int bgWidth = 250;
        int bgHeight = 308;
        int x = (this.width - bgWidth) / 2;
        int y = (this.height - bgHeight) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), btn -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }).bounds(x + 10, y + bgHeight - 60, 40, 40).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), btn -> {
            if (this.currentPage < 7) {
                ++this.currentPage;
            }
        }).bounds(x + bgWidth - 50, y + bgHeight - 60, 40, 40).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        int bgWidth = 250;
        int bgHeight = 308;
        int x = (this.width - bgWidth) / 2;
        int y = (this.height - bgHeight) / 2;
        graphics.blit(BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, bgWidth, bgHeight, bgWidth, bgHeight);
        ItemStack stack1 = null;
        ItemStack stack2 = null;
        ResourceLocation textureToDraw = null;
        switch (this.currentPage) {
            case 0: {
                stack1 = new ItemStack((ItemLike)ModItems.CUP_OF_COFFEE.asItem());
                break;
            }
            case 1: {
                stack1 = new ItemStack((ItemLike)ModBlocks.COFFEE_MACHINE.asItem());
                stack2 = new ItemStack((ItemLike)ModItems.COFFEE_CUP.asItem());
                break;
            }
            case 2: {
                stack1 = new ItemStack((ItemLike)ModItems.ARABICA_COFFEE_CHERRY.asItem());
                stack2 = new ItemStack((ItemLike)ModItems.RAW_ARABICA_COFFEE_BEAN.asItem());
                break;
            }
            case 3: {
                stack1 = new ItemStack((ItemLike)ModItems.LIGHT_ROASTED_ARABICA_COFFEE_BEAN.asItem());
                stack2 = new ItemStack((ItemLike)ModItems.DARK_ARABICA_GROUND_COFFEE.asItem());
                break;
            }
            case 4: {
                stack1 = new ItemStack((ItemLike)ModItems.ARABICA_COFFEE_CHERRY.asItem());
                textureToDraw = ResourceLocation.fromNamespaceAndPath((String)"zcoffeecraft2", (String)"textures/block/arabica_coffee_bush_stage7.png");
                break;
            }
            case 5: {
                stack1 = new ItemStack((ItemLike)ModItems.ROBUSTA_COFFEE_CHERRY.asItem());
                textureToDraw = ResourceLocation.fromNamespaceAndPath((String)"zcoffeecraft2", (String)"textures/block/robusta_coffee_bush_stage7.png");
                break;
            }
            case 6: {
                stack1 = new ItemStack((ItemLike)ModItems.LIBERICA_COFFEE_CHERRY.asItem());
                textureToDraw = ResourceLocation.fromNamespaceAndPath((String)"zcoffeecraft2", (String)"textures/block/liberica_coffee_bush_stage7.png");
                break;
            }
            case 7: {
                stack1 = new ItemStack((ItemLike)ModItems.WHISK.asItem());
                stack2 = new ItemStack((ItemLike)ModItems.WHIPPED_CREAM.asItem());
            }
        }
        if (stack1 != null) {
            this.drawItemStack(graphics, stack1, x + 25, y + 20);
        }
        if (textureToDraw == null && stack1 != null && stack2 == null) {
            this.drawItemStack(graphics, stack1, x + bgWidth - 25 - 32, y + 20);
        } else if (textureToDraw == null && stack2 != null) {
            this.drawItemStack(graphics, stack2, x + bgWidth - 25 - 32, y + 20);
        } else if (textureToDraw != null && stack2 == null) {
            graphics.blit(textureToDraw, x + bgWidth - 25 - 32, y + 20, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        this.drawLargeText(graphics, (Component)Component.translatable((String)("guide.zcoffeecraft2.title" + (this.currentPage + 1))), this.width / 2, y + 30);
        MutableComponent content = Component.translatable((String)("guide.zcoffeecraft2.page" + (this.currentPage + 1)));
        this.drawContent(graphics, (Component)content, x, y, bgWidth - 50);
        MutableComponent indicator = Component.literal((String)(this.currentPage + 1 + " / 8"));
        this.drawCenteredStringNoShadow(graphics, this.font, (Component)indicator, this.width / 2, y + bgHeight - 40, 0);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void drawCenteredStringNoShadow(GuiGraphics graphics, Font font, Component text, int x, int y, int color) {
        int textWidth = font.width((FormattedText)text);
        graphics.drawString(font, text, x - textWidth / 2, y, color, false);
    }

    private void drawItemStack(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 35.0f);
        graphics.pose().scale(2.0f, 2.0f, 1.0f);
        graphics.renderItem(stack, 0, 0);
        graphics.pose().popPose();
    }

    private void drawLargeText(GuiGraphics graphics, Component toDisplay, int x, int y) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 35.0f);
        graphics.pose().scale(1.5f, 1.5f, 1.0f);
        this.drawCenteredStringNoShadow(graphics, this.font, toDisplay, 0, 0, 0);
        graphics.pose().popPose();
    }

    private void drawContent(GuiGraphics graphics, Component content, int x, int y, int lineWidth) {
        String text = content.getString();
        String[] lines = text.split("\n");
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        for (int i = 0; i < lines.length; ++i) {
            graphics.drawWordWrap(this.font, (FormattedText)Component.literal((String)lines[i]), x + 25, y + 70 + i * lineHeight, lineWidth, 0);
        }
    }
}

