/*
 * Decompiled with CFR 0.152.
 */
package net.zusz.zcoffeecraft2.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.zusz.zcoffeecraft2.worldgen.ModConfiguredFeatures;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> ARABICA_COFFEE_BUSH_PLACED_KEY = ModPlacedFeatures.registerKey("arabica_coffee_bush_placed");
    public static final ResourceKey<PlacedFeature> ROBUSTA_COFFEE_BUSH_PLACED_KEY = ModPlacedFeatures.registerKey("robusta_coffee_bush_placed");
    public static final ResourceKey<PlacedFeature> LIBERICA_COFFEE_BUSH_PLACED_KEY = ModPlacedFeatures.registerKey("liberica_coffee_bush_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, ARABICA_COFFEE_BUSH_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ARABICA_COFFEE_BUSH_KEY), List.of(RarityFilter.onAverageOnceEvery((int)48), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, ROBUSTA_COFFEE_BUSH_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ROBUSTA_COFFEE_BUSH_KEY), List.of(RarityFilter.onAverageOnceEvery((int)12), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, LIBERICA_COFFEE_BUSH_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.LIBERICA_COFFEE_BUSH_KEY), List.of(RarityFilter.onAverageOnceEvery((int)12), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"zcoffeecraft2", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

