/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller.entities.goals;

import de.cadentem.cave_dweller.config.ServerConfig;
import de.cadentem.cave_dweller.entities.CaveDwellerEntity;
import de.cadentem.cave_dweller.entities.goals.Roll;
import de.cadentem.cave_dweller.util.Utils;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_9;

public class CaveDwellerChaseGoal
extends class_1352 {
    private final CaveDwellerEntity caveDweller;
    private final float ticksUntilChase;
    private final double speedModifier;
    private final int ticksToSqueeze;
    private final boolean canPenalize = false;
    private final boolean followTargetEvenIfNotSeen;
    private class_11 shortPath;
    private class_2338 nodePosition;
    private class_243 vecNodePosition;
    private class_243 vecMobPos;
    private class_243 xPathStartVec;
    private class_243 zPathStartVec;
    private class_243 xPathTargetVec;
    private class_243 zPathTargetVec;
    private class_243 vecTargetPos;
    private class_243 previousNodePosition;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private float currentTicksUntilChase;
    private long lastGameTimeCheck;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int failedPathFindingPenalty;
    private int currentTicksToSqueeze;
    private int ticksUntilLeave;
    private boolean squeezing;

    public CaveDwellerChaseGoal(CaveDwellerEntity caveDweller, double speedModifier, boolean followTargetEvenIfNotSeen, float ticksUntilChase) {
        this.caveDweller = caveDweller;
        this.speedModifier = speedModifier;
        this.followTargetEvenIfNotSeen = followTargetEvenIfNotSeen;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.ticksUntilChase = ticksUntilChase;
        this.currentTicksUntilChase = ticksUntilChase;
        this.ticksToSqueeze = 15;
        this.ticksUntilLeave = Utils.secondsToTicks(ServerConfig.TIME_UNTIL_LEAVE_CHASE);
    }

    public boolean method_6264() {
        boolean canAttack;
        if (this.caveDweller.method_5767()) {
            return false;
        }
        if (this.caveDweller.currentRoll != Roll.CHASE || !this.caveDweller.isLookingAtMe((class_1297)this.caveDweller.method_5968())) {
            return false;
        }
        long ticks = this.caveDweller.field_6002.method_8510();
        if (ticks - this.lastGameTimeCheck < 20L) {
            return false;
        }
        this.lastGameTimeCheck = ticks;
        class_1309 target = this.caveDweller.method_5968();
        if (target == null) {
            return false;
        }
        if (!target.method_5805()) {
            return false;
        }
        class_11 path = this.caveDweller.method_5942().method_6349((class_1297)target, 0);
        if (path != null) {
            return true;
        }
        boolean bl = canAttack = this.getAttackReachSqr(target) >= this.caveDweller.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        if (!canAttack) {
            path = this.caveDweller.createShortPath(target);
            return path != null;
        }
        return false;
    }

    public boolean method_6266() {
        class_1309 target = this.caveDweller.method_5968();
        if (target == null) {
            return false;
        }
        if (!target.method_5805()) {
            this.caveDweller.method_31472();
            return false;
        }
        if (!this.followTargetEvenIfNotSeen) {
            return !this.caveDweller.method_5942().method_6357();
        }
        if (!this.caveDweller.method_18407(target.method_24515())) {
            return false;
        }
        return Utils.isValidPlayer((class_1297)target);
    }

    public void method_6269() {
        this.caveDweller.method_19540(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void method_6270() {
        class_1309 target = this.caveDweller.method_5968();
        if (!Utils.isValidPlayer((class_1297)target)) {
            this.caveDweller.method_5980(null);
        }
        this.caveDweller.squeezeCrawling = false;
        this.caveDweller.method_5841().method_12778(CaveDwellerEntity.AGGRO_ACCESSOR, (Object)false);
        this.caveDweller.method_18382();
        this.currentTicksUntilChase = this.ticksUntilChase;
        this.caveDweller.method_5942().method_6340();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        this.caveDweller.squeezeCrawling = this.squeezing;
        class_1309 target = this.caveDweller.method_5968();
        this.tickAggroClock();
        if (!this.squeezing && target != null) {
            if (this.caveDweller.method_6510()) {
                this.caveDweller.method_5988().method_6226((class_1297)target, 90.0f, 90.0f);
            } else {
                this.caveDweller.method_5988().method_6226((class_1297)target, 180.0f, 1.0f);
            }
        }
        if (((Boolean)this.caveDweller.method_5841().method_12789(CaveDwellerEntity.AGGRO_ACCESSOR)).booleanValue()) {
            if (this.squeezing) {
                this.squeezingTick();
            } else {
                this.aggroTick();
            }
        }
        --this.ticksUntilLeave;
        if (!(this.ticksUntilLeave > 0 || this.caveDweller.isLookingAtMe((class_1297)target) && this.inPlayerLineOfSight())) {
            this.caveDweller.method_31472();
        }
    }

    private void tickAggroClock() {
        this.currentTicksUntilChase -= 1.0f;
        if (this.currentTicksUntilChase <= 0.0f) {
            this.caveDweller.method_5841().method_12778(CaveDwellerEntity.AGGRO_ACCESSOR, (Object)true);
        }
        this.caveDweller.method_18382();
    }

    private class_11 getShortPath(class_1309 target) {
        this.shortPath = this.caveDweller.createShortPath(target);
        return this.shortPath;
    }

    private void squeezingTick() {
        class_11 path = this.caveDweller.method_5942().method_6345();
        if (path != null && !path.method_46()) {
            this.nodePosition = path.method_31032();
        }
        this.caveDweller.method_5942().method_6340();
        if (this.nodePosition == null) {
            this.stopSqueezing();
        } else {
            if (this.vecNodePosition == null) {
                this.vecNodePosition = new class_243((double)this.nodePosition.method_10263(), (double)this.nodePosition.method_10264(), (double)this.nodePosition.method_10260());
            }
            this.previousNodePosition = this.vecNodePosition;
            class_243 vecOldMobPos = this.caveDweller.method_30950(1.0f);
            if (this.xPathStartVec == null) {
                if (vecOldMobPos.field_1352 < this.vecNodePosition.field_1352) {
                    this.xPathStartVec = new class_243(this.vecNodePosition.field_1352 - 1.0, this.vecNodePosition.field_1351 - 1.0, this.vecNodePosition.field_1350 + 0.5);
                    this.xPathTargetVec = new class_243(this.vecNodePosition.field_1352 + 1.0, this.vecNodePosition.field_1351 - 1.0, this.vecNodePosition.field_1350 + 0.5);
                } else {
                    this.xPathStartVec = new class_243(this.vecNodePosition.field_1352 + 1.0, this.vecNodePosition.field_1351 - 1.0, this.vecNodePosition.field_1350 + 0.5);
                    this.xPathTargetVec = new class_243(this.vecNodePosition.field_1352 - 1.0, this.vecNodePosition.field_1351 - 1.0, this.vecNodePosition.field_1350 + 0.5);
                }
            }
            if (this.zPathStartVec == null) {
                if (vecOldMobPos.field_1350 < this.vecNodePosition.field_1350) {
                    this.zPathStartVec = new class_243(this.vecNodePosition.field_1352 + 0.5, this.vecNodePosition.field_1351 - 1.0, this.vecNodePosition.field_1350 - 1.0);
                    this.zPathTargetVec = new class_243(this.vecNodePosition.field_1352 + 0.5, this.vecNodePosition.field_1351 - 1.0, this.vecNodePosition.field_1350 + 1.0);
                } else {
                    this.zPathStartVec = new class_243(this.vecNodePosition.field_1352 + 0.5, this.vecNodePosition.field_1351 - 1.0, this.vecNodePosition.field_1350 + 1.0);
                    this.zPathTargetVec = new class_243(this.vecNodePosition.field_1352 + 0.5, this.vecNodePosition.field_1351 - 1.0, this.vecNodePosition.field_1350 - 1.0);
                }
            }
            class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339(this.xPathTargetVec.field_1352, this.xPathTargetVec.field_1351, this.xPathTargetVec.field_1350);
            class_2680 blockstate = this.caveDweller.field_6002.method_8320((class_2338)blockpos$mutableblockpos);
            boolean xBlocked = blockstate.method_26207().method_15801();
            blockpos$mutableblockpos = new class_2338.class_2339(this.zPathTargetVec.field_1352, this.zPathTargetVec.field_1351, this.zPathTargetVec.field_1350);
            blockstate = this.caveDweller.field_6002.method_8320((class_2338)blockpos$mutableblockpos);
            boolean zBlocked = blockstate.method_26207().method_15801();
            if (xBlocked) {
                this.vecMobPos = this.zPathStartVec;
                this.vecTargetPos = this.zPathTargetVec;
            }
            if (zBlocked) {
                this.vecMobPos = this.xPathStartVec;
                this.vecTargetPos = this.xPathTargetVec;
            }
            if (this.vecTargetPos != null && this.vecMobPos != null) {
                ++this.currentTicksToSqueeze;
                float tickF = (float)this.currentTicksToSqueeze / (float)this.ticksToSqueeze;
                class_243 vecCurrentMobPos = new class_243(CaveDwellerChaseGoal.lerp(this.vecMobPos.field_1352, this.vecTargetPos.field_1352, tickF), this.vecMobPos.field_1351, CaveDwellerChaseGoal.lerp(this.vecMobPos.field_1350, this.vecTargetPos.field_1350, tickF));
                class_243 rotAxis = new class_243(this.vecTargetPos.field_1352 - this.vecMobPos.field_1352, 0.0, this.vecTargetPos.field_1350 - this.vecMobPos.field_1350);
                rotAxis = rotAxis.method_1029();
                double rotAngle = Math.toDegrees(Math.atan2(-rotAxis.field_1352, rotAxis.field_1350));
                this.caveDweller.method_5847((float)rotAngle);
                this.caveDweller.method_5808(vecCurrentMobPos.field_1352, vecCurrentMobPos.field_1351, vecCurrentMobPos.field_1350, (float)rotAngle, (float)rotAngle);
                if (tickF >= 1.0f) {
                    this.caveDweller.method_5814(this.vecTargetPos.field_1352, this.vecTargetPos.field_1351, this.vecTargetPos.field_1350);
                    this.stopSqueezing();
                }
            } else {
                this.stopSqueezing();
            }
        }
    }

    private void stopSqueezing() {
        this.squeezing = false;
        this.caveDweller.method_5841().method_12778(CaveDwellerEntity.SQUEEZING_ACCESSOR, (Object)false);
    }

    private void startSqueezing() {
        this.vecNodePosition = null;
        this.vecMobPos = null;
        this.xPathStartVec = null;
        this.zPathStartVec = null;
        this.xPathTargetVec = null;
        this.zPathTargetVec = null;
        this.vecTargetPos = null;
        this.currentTicksToSqueeze = 0;
        this.squeezing = true;
        this.caveDweller.method_5841().method_12778(CaveDwellerEntity.SQUEEZING_ACCESSOR, (Object)true);
        this.nodePosition = null;
    }

    private boolean shouldSqueeze(class_11 pathToCheck) {
        if (pathToCheck == null) {
            return false;
        }
        if (!pathToCheck.method_46()) {
            class_2338 blockPosition = pathToCheck.method_31032();
            if (this.previousNodePosition != null && blockPosition.method_10263() == (int)this.previousNodePosition.field_1352 && blockPosition.method_10264() == (int)this.previousNodePosition.field_1351 && blockPosition.method_10260() == (int)this.previousNodePosition.field_1350) {
                return false;
            }
            class_2680 blockstate = this.caveDweller.field_6002.method_8320(blockPosition.method_10084());
            return blockstate.method_26207().method_15801();
        }
        return false;
    }

    private void aggroTick() {
        class_9 finalPathPoint;
        this.caveDweller.playChaseSound();
        class_1309 target = this.caveDweller.method_5968();
        boolean shouldUseShortPath = true;
        class_11 path = this.caveDweller.method_5942().method_6345();
        if (path != null && (finalPathPoint = path.method_45()) != null && !path.method_46()) {
            shouldUseShortPath = false;
        }
        if (shouldUseShortPath) {
            path = this.getShortPath(target);
        }
        if (this.shouldSqueeze(path)) {
            this.startSqueezing();
            this.squeezing = true;
            this.caveDweller.method_5841().method_12778(CaveDwellerEntity.SQUEEZING_ACCESSOR, (Object)true);
        } else if (target != null) {
            double distance = this.caveDweller.method_5858((class_1297)target);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.ticksUntilNextPathRecalculation == 0 && (this.followTargetEvenIfNotSeen || this.caveDweller.method_5985().method_6369((class_1297)target)) && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.method_5649(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || (double)this.caveDweller.method_6051().method_43057() < 0.05)) {
                this.pathedTargetX = target.method_23317();
                this.pathedTargetY = target.method_23318();
                this.pathedTargetZ = target.method_23321();
                this.ticksUntilNextPathRecalculation = 2;
                if (distance > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distance > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                boolean canMoveTo = shouldUseShortPath ? this.caveDweller.method_5942().method_6334(this.shortPath, this.speedModifier) : this.caveDweller.method_5942().method_6335((class_1297)target, this.speedModifier);
                if (!canMoveTo) {
                    this.ticksUntilNextPathRecalculation += 8;
                }
                this.ticksUntilNextPathRecalculation = this.method_38847(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(target, distance);
        }
    }

    private boolean inPlayerLineOfSight() {
        class_1309 target = this.caveDweller.method_5968();
        return target != null && target.method_6057((class_1297)this.caveDweller);
    }

    private void checkAndPerformAttack(class_1309 target, double distanceToTarget) {
        double attackReach = this.getAttackReachSqr(target);
        if (distanceToTarget <= attackReach && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.caveDweller.method_6104(class_1268.field_5808);
            this.caveDweller.method_6121((class_1297)target);
        }
    }

    private void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.method_38847(20);
    }

    private double getAttackReachSqr(class_1309 target) {
        return this.caveDweller.method_17681() * 4.0f * this.caveDweller.method_17681() * 4.0f + target.method_17681();
    }

    private static double lerp(double a, double b, double f) {
        return (b - a) * f + a;
    }
}

