/*
 * Decompiled with CFR 0.152.
 */
package com.alfred.ai;

import com.alfred.ai.MCAIMod;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class JavaCAI {
    private static final String BASE_URL = "https://plus.character.ai/";
    private static final String NEO_URL = "https://neo.character.ai/";
    private static final String NEO_WS_URL = "wss://neo.character.ai/ws/";
    private final ObjectMapper mapper = new ObjectMapper();
    private final OkHttpClient client = new OkHttpClient();
    private String accountId;
    public final User user = new User();
    public final Character character = new Character();
    public final Chat chat = new Chat();

    public JavaCAI() {
        this.updateAuthorization();
    }

    public void tryGetAccountId() {
        if (!MCAIMod.CONFIG.general.authorization.isBlank()) {
            try {
                JsonNode me = this.request("chat/user/", "GET", null).get("user").get("user");
                this.accountId = me.get("id").asText();
            }
            catch (IOException e) {
                MCAIMod.LOGGER.error("Unable to get user data. Will require restart or the `/ai authorize` to be run.");
            }
        }
    }

    public void updateAuthorization() {
        this.tryGetAccountId();
    }

    public JsonNode request(String url, String method, JsonNode data) throws IOException {
        Request.Builder builder = new Request.Builder().url((String)(url.startsWith("http") ? url : BASE_URL + url));
        MediaType JSON = MediaType.parse("application/json; charset=utf-8");
        if ("GET".equalsIgnoreCase(method)) {
            builder.get();
        } else if ("POST".equalsIgnoreCase(method)) {
            builder.post(RequestBody.create(JSON, data != null ? data.toString() : "{}"));
        } else if ("PUT".equalsIgnoreCase(method)) {
            builder.put(RequestBody.create(JSON, data != null ? data.toString() : "{}"));
        } else if ("PATCH".equalsIgnoreCase(method)) {
            builder.patch(RequestBody.create(JSON, data != null ? data.toString() : "{}"));
        } else {
            throw new IllegalArgumentException("Invalid method: " + method);
        }
        builder.addHeader("Authorization", "Token " + MCAIMod.CONFIG.general.authorization);
        try (Response response = this.client.newCall(builder.build()).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code: " + String.valueOf(response));
            }
            String body = Objects.requireNonNull(response.body()).string();
            JsonNode jsonNode = this.mapper.readTree(body);
            return jsonNode;
        }
    }

    private Headers buildNeoHeaders() {
        Headers.Builder hb = new Headers.Builder();
        hb.add("Authorization", "Token " + MCAIMod.CONFIG.general.authorization);
        hb.add("Accept", "application/json");
        hb.add("Content-Type", "application/json");
        return hb.build();
    }

    public JsonNode ping() throws IOException {
        return this.request("ping/", "GET", null);
    }

    public class User {
        public JsonNode fetchUser(String username) throws IOException {
            ObjectNode data = JavaCAI.this.mapper.createObjectNode().put("username", username);
            JsonNode res = JavaCAI.this.request("chat/user/public/", "POST", data);
            if (res.has("public_user")) {
                return res.get("public_user");
            }
            return null;
        }

        public JsonNode fetchUserVoices(String username) throws IOException {
            JsonNode res = JavaCAI.this.request("https://neo.character.ai/multimodal/api/v1/voices/search?creatorInfo.username=" + username, "GET", null);
            if (res.has("command") && "neo_error".equals(res.get("command").asText())) {
                throw new IOException("Cannot fetch user voices: " + res.get("comment").asText());
            }
            return res;
        }

        public boolean followUser(String username) throws IOException {
            ObjectNode data = JavaCAI.this.mapper.createObjectNode().put("username", username);
            JsonNode res = JavaCAI.this.request("chat/user/follow/", "POST", data);
            return res.has("status") && "OK".equals(res.get("status").asText());
        }

        public boolean unfollowUser(String username) throws IOException {
            ObjectNode data = JavaCAI.this.mapper.createObjectNode().put("username", username);
            JsonNode res = JavaCAI.this.request("chat/user/unfollow/", "POST", data);
            return res.has("status") && "OK".equals(res.get("status").asText());
        }
    }

    public class Character {
        public JsonNode getInfo(String characterId) throws IOException {
            ObjectNode data = new ObjectMapper().createObjectNode().put("external_id", characterId);
            return JavaCAI.this.request("https://neo.character.ai/character/v1/get_character_info", "POST", data);
        }
    }

    public class Chat {
        public JsonNode fetchHistories(String characterId, int amount) throws IOException {
            ObjectNode body = JavaCAI.this.mapper.createObjectNode().put("external_id", characterId).put("number", amount);
            Request req = new Request.Builder().url("https://neo.character.ai/chat/character/histories/").post(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), body.toString())).headers(JavaCAI.this.buildNeoHeaders()).build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (resp.code() == 200) {
                    JsonNode jsonNode = json;
                    return jsonNode;
                }
                throw new IOException("Cannot fetch histories. " + String.valueOf(json));
            }
        }

        public JsonNode fetchChats(String characterId, Integer numPreviewTurns) throws IOException {
            int n = numPreviewTurns != null ? numPreviewTurns : 2;
            HttpUrl url = HttpUrl.parse("https://neo.character.ai/chats/").newBuilder().addQueryParameter("character_ids", characterId).addQueryParameter("num_preview_turns", String.valueOf(n)).build();
            Request req = new Request.Builder().url(url).headers(JavaCAI.this.buildNeoHeaders()).get().build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (resp.code() == 200) {
                    JsonNode jsonNode = json;
                    return jsonNode;
                }
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot fetch chats. " + json.path("comment").asText());
                }
                throw new IOException("Cannot fetch chats. " + String.valueOf(json));
            }
        }

        public JsonNode fetchChat(String chatId) throws IOException {
            Request req = new Request.Builder().url("https://neo.character.ai/chat/" + chatId + "/").headers(JavaCAI.this.buildNeoHeaders()).get().build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (resp.code() == 200) {
                    JsonNode jsonNode = json;
                    return jsonNode;
                }
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot fetch chat. " + json.path("comment").asText());
                }
                throw new IOException("Cannot fetch chat. " + String.valueOf(json));
            }
        }

        public JsonNode fetchRecentChats() throws IOException {
            Request req = new Request.Builder().url("https://neo.character.ai/chats/recent/").headers(JavaCAI.this.buildNeoHeaders()).get().build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (resp.code() == 200) {
                    JsonNode jsonNode = json;
                    return jsonNode;
                }
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot fetch recent chats. " + json.path("comment").asText());
                }
                throw new IOException("Cannot fetch recent chats. " + String.valueOf(json));
            }
        }

        public MessagesPage fetchMessages(String chatId, boolean pinnedOnly, String nextToken) throws IOException {
            String url = "https://neo.character.ai/turns/" + chatId + "/";
            if (nextToken != null && !nextToken.isEmpty()) {
                url = url + "?next_token=" + URLEncoder.encode(nextToken, StandardCharsets.UTF_8);
            }
            Request req = new Request.Builder().url(url).headers(JavaCAI.this.buildNeoHeaders()).get().build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (resp.code() == 200) {
                    ArrayList<JsonNode> turns = new ArrayList<JsonNode>();
                    JsonNode rawTurns = json.path("turns");
                    if (rawTurns.isArray()) {
                        for (JsonNode t : rawTurns) {
                            boolean isPinned = t.path("is_pinned").asBoolean(false);
                            if (pinnedOnly && !isPinned) continue;
                            turns.add(t);
                        }
                    }
                    String newNext = json.path("meta").path("next_token").isMissingNode() ? null : json.path("meta").path("next_token").asText(null);
                    MessagesPage messagesPage = new MessagesPage(turns, newNext, json);
                    return messagesPage;
                }
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot fetch messages. " + json.path("comment").asText());
                }
                throw new IOException("Cannot fetch messages. " + String.valueOf(json));
            }
        }

        public List<JsonNode> getHistory(String chatId, boolean pinnedOnly) throws IOException {
            MessagesPage page;
            ArrayList<JsonNode> all = new ArrayList<JsonNode>();
            String next = null;
            do {
                page = this.fetchMessages(chatId, pinnedOnly, next);
                if (page.turns == null || page.turns.isEmpty()) break;
                all.addAll(page.turns);
            } while ((next = page.nextToken) != null && !next.isEmpty());
            return all;
        }

        public boolean deleteMessages(String chatId, List<String> turnIds) throws IOException {
            ObjectNode body = JavaCAI.this.mapper.createObjectNode();
            body.putPOJO("turn_ids", turnIds);
            Request req = new Request.Builder().url("https://neo.character.ai/turns/" + chatId + "/remove").post(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), body.toString())).headers(JavaCAI.this.buildNeoHeaders()).build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (resp.code() == 200) {
                    boolean bl = true;
                    return bl;
                }
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot delete messages. " + json.path("comment").asText());
                }
                throw new IOException("Cannot delete messages. " + String.valueOf(json));
            }
        }

        public boolean updateChatName(String chatId, String name) throws IOException {
            ObjectNode body = JavaCAI.this.mapper.createObjectNode().put("name", name);
            Request req = new Request.Builder().url("https://neo.character.ai/chat/" + chatId + "/update_name").patch(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), body.toString())).headers(JavaCAI.this.buildNeoHeaders()).build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                if (resp.code() == 200) {
                    boolean bl = true;
                    return bl;
                }
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot update chat name. " + json.path("comment").asText());
                }
                throw new IOException("Cannot update chat name. " + String.valueOf(json));
            }
        }

        public boolean archiveChat(String chatId) throws IOException {
            Request req = new Request.Builder().url("https://neo.character.ai/chat/" + chatId + "/archive").patch(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), "{}")).headers(JavaCAI.this.buildNeoHeaders()).build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                if (resp.code() == 200) {
                    boolean bl = true;
                    return bl;
                }
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot archive chat. " + json.path("comment").asText());
                }
                throw new IOException("Cannot archive chat. " + String.valueOf(json));
            }
        }

        public boolean unarchiveChat(String chatId) throws IOException {
            Request req = new Request.Builder().url("https://neo.character.ai/chat/" + chatId + "/unarchive").patch(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), "{}")).headers(JavaCAI.this.buildNeoHeaders()).build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                if (resp.code() == 200) {
                    boolean bl = true;
                    return bl;
                }
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot unarchive chat. " + json.path("comment").asText());
                }
                throw new IOException("Cannot unarchive chat. " + String.valueOf(json));
            }
        }

        public String copyChat(String chatId, String endTurnId) throws IOException {
            ObjectNode body = JavaCAI.this.mapper.createObjectNode().put("end_turn_id", endTurnId);
            Request req = new Request.Builder().url("https://neo.character.ai/chat/" + chatId + "/copy").post(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), body.toString())).headers(JavaCAI.this.buildNeoHeaders()).build();
            try (Response resp = JavaCAI.this.client.newCall(req).execute();){
                String b = Objects.requireNonNull(resp.body()).string();
                JsonNode json = JavaCAI.this.mapper.readTree(b);
                if (resp.code() == 200) {
                    String string = json.has("new_chat_id") ? json.get("new_chat_id").asText(null) : null;
                    return string;
                }
                if (json.has("command") && "neo_error".equals(json.get("command").asText())) {
                    throw new IOException("Cannot copy chat. " + json.path("comment").asText());
                }
                throw new IOException("Cannot copy chat. " + String.valueOf(json));
            }
        }

        private CompletableFuture<Void> wsSendAndReceive(final ObjectNode message, final StreamListener listener, long timeoutMillis) {
            final CompletableFuture<Void> done = new CompletableFuture<Void>();
            Request wsReq = new Request.Builder().url(JavaCAI.NEO_WS_URL).headers(JavaCAI.this.buildNeoHeaders()).build();
            WebSocketListener wl = new WebSocketListener(){

                @Override
                public void onOpen(WebSocket webSocket, Response response) {
                    try {
                        webSocket.send(message.toString());
                    }
                    catch (Exception e) {
                        listener.onError(e);
                        done.completeExceptionally(e);
                        webSocket.close(1000, "error");
                    }
                }

                @Override
                public void onMessage(WebSocket webSocket, String text) {
                    try {
                        JsonNode node = JavaCAI.this.mapper.readTree(text);
                        listener.onEvent(node);
                    }
                    catch (Exception e) {
                        listener.onError(e);
                        done.completeExceptionally(e);
                        webSocket.close(1000, "error");
                    }
                }

                @Override
                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    this.onMessage(webSocket, bytes.utf8());
                }

                @Override
                public void onClosing(WebSocket webSocket, int code, String reason) {
                    webSocket.close(1000, null);
                }

                @Override
                public void onClosed(WebSocket webSocket, int code, String reason) {
                    listener.onClose();
                    done.complete(null);
                }

                @Override
                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    listener.onError(t);
                    done.completeExceptionally(t);
                }
            };
            WebSocket ws = JavaCAI.this.client.newWebSocket(wsReq, wl);
            if (timeoutMillis > 0L) {
                ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor();
                ses.schedule(() -> {
                    if (!done.isDone()) {
                        done.completeExceptionally(new TimeoutException("WebSocket timed out"));
                        try {
                            ws.close(1000, "timeout");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ses.shutdown();
                }, timeoutMillis, TimeUnit.MILLISECONDS);
            }
            return done;
        }

        public CompletableFuture<Map<String, JsonNode>> newChat(String characterId, final boolean greeting, String modelType) {
            final CompletableFuture<Map<String, JsonNode>> result = new CompletableFuture<Map<String, JsonNode>>();
            String requestId = UUID.randomUUID().toString();
            String chatId = UUID.randomUUID().toString();
            ObjectNode payload = JavaCAI.this.mapper.createObjectNode();
            ObjectNode chatNode = JavaCAI.this.mapper.createObjectNode();
            chatNode.put("chat_id", chatId);
            chatNode.put("creator_id", JavaCAI.this.accountId);
            chatNode.put("visibility", "VISIBILITY_PRIVATE");
            chatNode.put("character_id", characterId);
            chatNode.put("type", "TYPE_ONE_ON_ONE");
            if (modelType != null && !modelType.isBlank()) {
                chatNode.put("preferred_model_type", modelType);
            }
            payload.set("chat", chatNode);
            payload.put("with_greeting", greeting);
            ObjectNode message = JavaCAI.this.mapper.createObjectNode();
            message.put("command", "create_chat");
            message.put("request_id", requestId);
            message.set("payload", payload);
            final JsonNode[] newChat = new JsonNode[1];
            final JsonNode[] greetingTurn = new JsonNode[1];
            StreamListener l = new StreamListener(){

                @Override
                public void onEvent(JsonNode event) {
                    String cmd;
                    String string = cmd = event.path("command").asText("");
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"create_chat_response", "add_turn", "neo_error"}, (Object)string, n)) {
                        case 0: {
                            newChat[0] = event.path("chat");
                            if (greeting) break;
                            HashMap<String, JsonNode> out = new HashMap<String, JsonNode>();
                            out.put("chat", newChat[0]);
                            out.put("greeting_turn", null);
                            result.complete(out);
                            break;
                        }
                        case 1: {
                            JsonNode turn;
                            greetingTurn[0] = turn = event.path("turn");
                            if (newChat[0] == null) {
                                // empty if block
                            }
                            HashMap<String, JsonNode> out = new HashMap<String, JsonNode>();
                            out.put("chat", newChat[0]);
                            out.put("greeting_turn", greetingTurn[0]);
                            result.complete(out);
                            break;
                        }
                        case 2: {
                            result.completeExceptionally(new RuntimeException("Cannot create a new chat. " + event.path("comment").asText("")));
                            break;
                        }
                    }
                }

                @Override
                public void onError(Throwable t) {
                    result.completeExceptionally(t);
                }

                @Override
                public void onClose() {
                    if (!result.isDone()) {
                        result.completeExceptionally(new RuntimeException("Session closed before chat creation finished"));
                    }
                }
            };
            this.wsSendAndReceive(message, l, 120000L).exceptionally(ex -> {
                if (!result.isDone()) {
                    result.completeExceptionally((Throwable)ex);
                }
                return null;
            });
            return result;
        }

        public CompletableFuture<JsonNode> sendMessage(String characterId, String chatId, String text, boolean streaming) {
            String[] annKeys;
            final CompletableFuture<JsonNode> finalResult = new CompletableFuture<JsonNode>();
            String candidateId = UUID.randomUUID().toString();
            String turnId = UUID.randomUUID().toString();
            String requestId = UUID.randomUUID().toString();
            ObjectNode payload = JavaCAI.this.mapper.createObjectNode();
            payload.put("character_id", characterId);
            payload.put("num_candidates", 1);
            ObjectNode prevAnn = JavaCAI.this.mapper.createObjectNode();
            for (String k : annKeys = new String[]{"bad_memory", "boring", "ends_chat_early", "funny", "helpful", "inaccurate", "interesting", "long", "not_bad_memory", "not_boring", "not_ends_chat_early", "not_funny", "not_helpful", "not_inaccurate", "not_interesting", "not_long", "not_out_of_character", "not_repetitive", "not_short", "out_of_character", "repetitive", "short"}) {
                prevAnn.put(k, 0);
            }
            payload.set("previous_annotations", prevAnn);
            payload.put("selected_language", "");
            payload.put("tts_enabled", false);
            ObjectNode turn = JavaCAI.this.mapper.createObjectNode();
            ObjectNode author = JavaCAI.this.mapper.createObjectNode();
            author.put("author_id", JavaCAI.this.accountId);
            author.put("is_human", true);
            author.put("name", "");
            turn.set("author", author);
            ObjectNode candidate = JavaCAI.this.mapper.createObjectNode();
            candidate.put("candidate_id", candidateId);
            candidate.put("raw_content", text);
            turn.putArray("candidates").add(candidate);
            turn.put("primary_candidate_id", candidateId);
            ObjectNode turnKey = JavaCAI.this.mapper.createObjectNode();
            ObjectNode tk = JavaCAI.this.mapper.createObjectNode();
            tk.put("chat_id", chatId);
            tk.put("turn_id", turnId);
            turn.set("turn_key", tk);
            payload.set("turn", turn);
            payload.put("user_name", "");
            ObjectNode message = JavaCAI.this.mapper.createObjectNode();
            message.put("command", "create_and_generate_turn");
            message.put("origin_id", "web-next");
            message.set("payload", payload);
            message.put("request_id", requestId);
            if (streaming) {
                StreamListener l = new StreamListener(){

                    @Override
                    public void onEvent(JsonNode event) {
                        String cmd = event.path("command").asText("");
                        if ("neo_error".equals(cmd)) {
                            finalResult.completeExceptionally(new RuntimeException("Cannot send message. " + event.path("comment").asText("")));
                            return;
                        }
                        if ("add_turn".equals(cmd) || "update_turn".equals(cmd)) {
                            boolean isFinal;
                            JsonNode turnNode = event.path("turn");
                            boolean authorIsHuman = turnNode.path("author").path("is_human").asBoolean(false);
                            if (authorIsHuman) {
                                return;
                            }
                            JsonNode primaryCandidate = null;
                            try {
                                if (turnNode.has("candidates") && turnNode.get("candidates").isArray() && !turnNode.get("candidates").isEmpty()) {
                                    primaryCandidate = turnNode.get("candidates").get(0);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            boolean bl = isFinal = primaryCandidate != null && primaryCandidate.path("is_final").asBoolean(false);
                            if (isFinal) {
                                finalResult.complete(turnNode);
                            }
                        } else if ("filter_user_input_self_harm".equals(cmd)) {
                            finalResult.completeExceptionally(new RuntimeException("Cannot send message. Self harm message detected"));
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        finalResult.completeExceptionally(t);
                    }

                    @Override
                    public void onClose() {
                        if (!finalResult.isDone()) {
                            finalResult.completeExceptionally(new RuntimeException("Stream closed without final result"));
                        }
                    }
                };
                this.wsSendAndReceive(message, l, 120000L).exceptionally(ex -> {
                    if (!finalResult.isDone()) {
                        finalResult.completeExceptionally((Throwable)ex);
                    }
                    return null;
                });
            } else {
                StreamListener l = new StreamListener(){

                    @Override
                    public void onEvent(JsonNode event) {
                        String cmd = event.path("command").asText("");
                        if ("neo_error".equals(cmd)) {
                            finalResult.completeExceptionally(new RuntimeException("Cannot send message. " + event.path("comment").asText("")));
                            return;
                        }
                        if ("add_turn".equals(cmd) || "update_turn".equals(cmd)) {
                            JsonNode turnNode = event.path("turn");
                            boolean authorIsHuman = turnNode.path("author").path("is_human").asBoolean(false);
                            if (authorIsHuman) {
                                return;
                            }
                            JsonNode primaryCandidate = null;
                            if (turnNode.has("candidates") && turnNode.get("candidates").isArray() && !turnNode.get("candidates").isEmpty()) {
                                primaryCandidate = turnNode.get("candidates").get(0);
                            }
                            if (primaryCandidate != null && primaryCandidate.path("is_final").asBoolean(false)) {
                                finalResult.complete(turnNode);
                            }
                        } else if ("filter_user_input_self_harm".equals(cmd)) {
                            finalResult.completeExceptionally(new RuntimeException("Cannot send message. Self harm message detected"));
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        finalResult.completeExceptionally(t);
                    }

                    @Override
                    public void onClose() {
                        if (!finalResult.isDone()) {
                            finalResult.completeExceptionally(new RuntimeException("Stream closed without final result"));
                        }
                    }
                };
                this.wsSendAndReceive(message, l, 120000L).exceptionally(ex -> {
                    if (!finalResult.isDone()) {
                        finalResult.completeExceptionally((Throwable)ex);
                    }
                    return null;
                });
            }
            return finalResult;
        }

        public CompletableFuture<JsonNode> anotherResponse(String characterId, String chatId, String turnId) {
            String[] annKeys;
            final CompletableFuture<JsonNode> finalResult = new CompletableFuture<JsonNode>();
            String requestId = UUID.randomUUID().toString();
            ObjectNode payload = JavaCAI.this.mapper.createObjectNode();
            payload.put("character_id", characterId);
            ObjectNode prevAnn = JavaCAI.this.mapper.createObjectNode();
            for (String k : annKeys = new String[]{"bad_memory", "boring", "ends_chat_early", "funny", "helpful", "inaccurate", "interesting", "long", "not_bad_memory", "not_boring", "not_ends_chat_early", "not_funny", "not_helpful", "not_inaccurate", "not_interesting", "not_long", "not_out_of_character", "not_repetitive", "not_short", "out_of_character", "repetitive", "short"}) {
                prevAnn.put(k, 0);
            }
            payload.set("previous_annotations", prevAnn);
            payload.put("selected_language", "");
            payload.put("tts_enabled", false);
            ObjectNode tk = JavaCAI.this.mapper.createObjectNode();
            tk.put("chat_id", chatId);
            tk.put("turn_id", turnId);
            payload.set("turn_key", tk);
            payload.put("user_name", "");
            ObjectNode message = JavaCAI.this.mapper.createObjectNode();
            message.put("command", "generate_turn_candidate");
            message.put("origin_id", "web-next");
            message.set("payload", payload);
            message.put("request_id", requestId);
            StreamListener l = new StreamListener(){

                @Override
                public void onEvent(JsonNode event) {
                    String cmd = event.path("command").asText("");
                    if ("neo_error".equals(cmd)) {
                        finalResult.completeExceptionally(new RuntimeException("Cannot generate another response. " + event.path("comment").asText("")));
                        return;
                    }
                    if ("update_turn".equals(cmd)) {
                        JsonNode turn = event.path("turn");
                        JsonNode primaryCandidate = null;
                        if (turn.has("candidates") && turn.get("candidates").isArray() && turn.get("candidates").size() > 0) {
                            primaryCandidate = turn.get("candidates").get(0);
                        }
                        if (primaryCandidate != null && primaryCandidate.path("is_final").asBoolean(false)) {
                            finalResult.complete(turn);
                        }
                    }
                }

                @Override
                public void onError(Throwable t) {
                    finalResult.completeExceptionally(t);
                }

                @Override
                public void onClose() {
                    if (!finalResult.isDone()) {
                        finalResult.completeExceptionally(new RuntimeException("Session closed"));
                    }
                }
            };
            this.wsSendAndReceive(message, l, 120000L).exceptionally(ex -> {
                if (!finalResult.isDone()) {
                    finalResult.completeExceptionally((Throwable)ex);
                }
                return null;
            });
            return finalResult;
        }

        public CompletableFuture<JsonNode> editMessage(String chatId, String turnId, String candidateId, String newText) {
            final CompletableFuture<JsonNode> finalResult = new CompletableFuture<JsonNode>();
            String requestId = UUID.randomUUID().toString();
            ObjectNode payload = JavaCAI.this.mapper.createObjectNode();
            ObjectNode turnKey = JavaCAI.this.mapper.createObjectNode();
            turnKey.put("chat_id", chatId);
            turnKey.put("turn_id", turnId);
            payload.set("turn_key", turnKey);
            payload.put("current_candidate_id", candidateId);
            payload.put("new_candidate_raw_content", newText);
            ObjectNode message = JavaCAI.this.mapper.createObjectNode();
            message.put("command", "edit_turn_candidate");
            message.put("request_id", requestId);
            message.set("payload", payload);
            message.put("origin_id", "web-next");
            StreamListener l = new StreamListener(){

                @Override
                public void onEvent(JsonNode event) {
                    String cmd = event.path("command").asText("");
                    if ("neo_error".equals(cmd)) {
                        finalResult.completeExceptionally(new RuntimeException("Cannot edit message. " + event.path("comment").asText("")));
                        return;
                    }
                    if ("update_turn".equals(cmd)) {
                        finalResult.complete(event.path("turn"));
                    }
                }

                @Override
                public void onError(Throwable t) {
                    finalResult.completeExceptionally(t);
                }

                @Override
                public void onClose() {
                    if (!finalResult.isDone()) {
                        finalResult.completeExceptionally(new RuntimeException("Session closed"));
                    }
                }
            };
            this.wsSendAndReceive(message, l, 60000L).exceptionally(ex -> {
                if (!finalResult.isDone()) {
                    finalResult.completeExceptionally((Throwable)ex);
                }
                return null;
            });
            return finalResult;
        }

        public boolean deleteMessage(String chatId, String turnId) throws IOException {
            return this.deleteMessages(chatId, Collections.singletonList(turnId));
        }

        public CompletableFuture<Boolean> pinMessage(String chatId, String turnId) {
            final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
            String reqId = UUID.randomUUID().toString();
            ObjectNode payload = JavaCAI.this.mapper.createObjectNode();
            ObjectNode turnKey = JavaCAI.this.mapper.createObjectNode();
            turnKey.put("chat_id", chatId);
            turnKey.put("turn_id", turnId);
            payload.put("is_pinned", true);
            payload.set("turn_key", turnKey);
            ObjectNode message = JavaCAI.this.mapper.createObjectNode();
            message.put("command", "set_turn_pin");
            message.put("origin_id", "web-next");
            message.set("payload", payload);
            message.put("request_id", reqId);
            StreamListener l = new StreamListener(){

                @Override
                public void onEvent(JsonNode event) {
                    String cmd = event.path("command").asText("");
                    if ("neo_error".equals(cmd)) {
                        result.completeExceptionally(new RuntimeException("Cannot pin message. " + event.path("comment").asText("")));
                        return;
                    }
                    if ("update_turn".equals(cmd)) {
                        boolean isPinned = event.path("turn").path("is_pinned").asBoolean(false);
                        result.complete(isPinned);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    result.completeExceptionally(t);
                }

                @Override
                public void onClose() {
                    if (!result.isDone()) {
                        result.completeExceptionally(new RuntimeException("Session closed"));
                    }
                }
            };
            this.wsSendAndReceive(message, l, 30000L).exceptionally(ex -> {
                if (!result.isDone()) {
                    result.completeExceptionally((Throwable)ex);
                }
                return null;
            });
            return result;
        }

        public CompletableFuture<Boolean> unpinMessage(String chatId, String turnId) {
            final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
            String reqId = UUID.randomUUID().toString();
            ObjectNode payload = JavaCAI.this.mapper.createObjectNode();
            ObjectNode turnKey = JavaCAI.this.mapper.createObjectNode();
            turnKey.put("chat_id", chatId);
            turnKey.put("turn_id", turnId);
            payload.put("is_pinned", false);
            payload.set("turn_key", turnKey);
            ObjectNode message = JavaCAI.this.mapper.createObjectNode();
            message.put("command", "set_turn_pin");
            message.put("origin_id", "web-next");
            message.set("payload", payload);
            message.put("request_id", reqId);
            StreamListener l = new StreamListener(){

                @Override
                public void onEvent(JsonNode event) {
                    String cmd = event.path("command").asText("");
                    if ("neo_error".equals(cmd)) {
                        result.completeExceptionally(new RuntimeException("Cannot unpin message. " + event.path("comment").asText("")));
                        return;
                    }
                    if ("update_turn".equals(cmd)) {
                        boolean isPinned = event.path("turn").path("is_pinned").asBoolean(true);
                        result.complete(!isPinned);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    result.completeExceptionally(t);
                }

                @Override
                public void onClose() {
                    if (!result.isDone()) {
                        result.completeExceptionally(new RuntimeException("Session closed"));
                    }
                }
            };
            this.wsSendAndReceive(message, l, 30000L).exceptionally(ex -> {
                if (!result.isDone()) {
                    result.completeExceptionally((Throwable)ex);
                }
                return null;
            });
            return result;
        }

        public CompletableFuture<Boolean> updatePrimaryCandidate(String chatId, String turnId, String candidateId) {
            final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
            ObjectNode payload = JavaCAI.this.mapper.createObjectNode();
            payload.put("candidate_id", candidateId);
            ObjectNode turnKey = JavaCAI.this.mapper.createObjectNode();
            turnKey.put("chat_id", chatId);
            turnKey.put("turn_id", turnId);
            payload.set("turn_key", turnKey);
            ObjectNode wsMessage = JavaCAI.this.mapper.createObjectNode();
            wsMessage.put("command", "update_primary_candidate");
            wsMessage.put("origin_id", "web-next");
            wsMessage.set("payload", payload);
            StreamListener l = new StreamListener(){

                @Override
                public void onEvent(JsonNode event) {
                    String cmd = event.path("command").asText("");
                    if ("neo_error".equals(cmd)) {
                        result.completeExceptionally(new RuntimeException("Cannot update primary candidate. " + event.path("comment").asText("")));
                        return;
                    }
                    if ("ok".equals(cmd)) {
                        result.complete(true);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    result.completeExceptionally(t);
                }

                @Override
                public void onClose() {
                    if (!result.isDone()) {
                        result.complete(false);
                    }
                }
            };
            this.wsSendAndReceive(wsMessage, l, 30000L).exceptionally(ex -> {
                if (!result.isDone()) {
                    result.completeExceptionally((Throwable)ex);
                }
                return null;
            });
            return result;
        }

        public static interface StreamListener {
            public void onEvent(JsonNode var1);

            public void onError(Throwable var1);

            public void onClose();
        }
    }

    public record MessagesPage(List<JsonNode> turns, String nextToken, JsonNode raw) {
    }
}

