/*
 * Decompiled with CFR 0.152.
 */
package com.alfred.ai;

import com.alfred.ai.MCAIConfig;
import com.alfred.ai.MCAIMod;
import com.alfred.ai.Tuple;
import com.fasterxml.jackson.databind.JsonNode;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class MCAICommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ai").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"register").requires(source2 -> source2.method_9259(MCAIMod.CONFIG.general.adminPermissionLevel) || Objects.requireNonNull(source2.method_44023()).method_7340())).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"character_id", (ArgumentType)StringArgumentType.word()).executes(context -> MCAICommands.registerCharacter((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"character_id"), ""))).then(class_2170.method_9244((String)"aliases", (ArgumentType)StringArgumentType.greedyString()).executes(context -> MCAICommands.registerCharacter((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"character_id"), StringArgumentType.getString((CommandContext)context, (String)"aliases"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unregister").requires(source2 -> source2.method_9259(MCAIMod.CONFIG.general.adminPermissionLevel) || Objects.requireNonNull(source2.method_44023()).method_7340())).then(class_2170.method_9244((String)"character_id", (ArgumentType)StringArgumentType.word()).executes(context -> MCAICommands.unregisterCharacter((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"character_id")))))).then(class_2170.method_9247((String)"talk").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> MCAICommands.talk((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"text"))))))).then(class_2170.method_9247((String)"context").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> MCAICommands.getContext((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"broadcast", (ArgumentType)BoolArgumentType.bool()).requires(source2 -> source2.method_9259(MCAIMod.CONFIG.general.adminPermissionLevel) || Objects.requireNonNull(source2.method_44023()).method_7340())).executes(context -> MCAICommands.getContext((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), BoolArgumentType.getBool((CommandContext)context, (String)"broadcast"))))))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> MCAICommands.newChat((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> MCAICommands.toggleAI((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), false))))).then(class_2170.method_9247((String)"disable").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> MCAICommands.toggleAI((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), true))))).then(class_2170.method_9247((String)"authorize").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"token", (ArgumentType)StringArgumentType.word()).requires(source2 -> source2.method_9259(MCAIMod.CONFIG.general.adminPermissionLevel) || Objects.requireNonNull(source2.method_44023()).method_7340())).executes(context -> MCAICommands.authorize((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"token")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source2 -> source2.method_9259(MCAIMod.CONFIG.general.adminPermissionLevel) || Objects.requireNonNull(source2.method_44023()).method_7340())).executes(context -> {
            MCAIConfig.load();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"mcai.messages.config_reload_success"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"list").executes(context -> MCAICommands.list((class_2168)context.getSource()))));
    }

    private static int registerCharacter(class_2168 source2, String characterID, String aliases) {
        if (!MCAIMod.CONFIG.ais.stream().anyMatch(tuple -> tuple.id.equals(characterID))) {
            try {
                String[] aliasList = aliases.isBlank() ? new String[]{} : aliases.strip().split("\\s+");
                JsonNode json = MCAIMod.CHARACTER_AI.character.getInfo(characterID).get("character");
                String name = json.has("participant__name") ? json.get("participant__name").asText("Unknown") : (json.has("name") ? json.get("name").asText("Unknown") : "Unknown");
                MCAIMod.CONFIG.ais.add(new MCAIConfig.CharacterTuple(name, characterID, "", aliasList));
                MCAIConfig.save();
                source2.method_9226(() -> class_2561.method_43469((String)"mcai.messages.character_register_success", (Object[])new Object[]{name, name}), true);
                return 1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        source2.method_9213((class_2561)class_2561.method_43471((String)"mcai.errors.character_id_exists"));
        return 0;
    }

    private static int unregisterCharacter(class_2168 source2, String characterID) {
        for (MCAIConfig.CharacterTuple tuple : MCAIMod.CONFIG.ais) {
            if (!tuple.id.equals(characterID)) continue;
            MCAIMod.CONFIG.ais.remove(tuple);
            MCAIConfig.save();
            source2.method_9226(() -> class_2561.method_43469((String)"mcai.messages.character_unregister_success", (Object[])new Object[]{tuple.name}), true);
            return 1;
        }
        source2.method_9213((class_2561)class_2561.method_43471((String)"errors.nonexistent_character_id"));
        return 0;
    }

    private static int talk(class_2168 source2, String name, String text) {
        boolean foundAnAI = false;
        for (MCAIConfig.CharacterTuple tuple : MCAIMod.CONFIG.ais) {
            if (!tuple.name.equalsIgnoreCase(name) && !Arrays.stream(tuple.aliases).anyMatch(alias -> alias.equalsIgnoreCase(name))) continue;
            foundAnAI = true;
            if (tuple.disabled) continue;
            MCAIMod.sendAIMessage(text, tuple, source2.method_9214(), MCAIMod.CONFIG.general.format, MCAIMod.CONFIG.general.replyFormat, source2.method_9211());
            return 1;
        }
        source2.method_9213((class_2561)class_2561.method_43469((String)(!foundAnAI ? "mcai.errors.ai_not_found" : "mcai.errors.no_suitable_ai_found"), (Object[])new Object[]{name}));
        return 0;
    }

    public static String sub(String input, String pattern, Function<String, String> replacementFunction) {
        Pattern regexPattern = Pattern.compile(pattern);
        Matcher matcher = regexPattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = replacementFunction.apply(match);
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static Tuple<String> reverseFormat(String formatString, String formattedString) {
        String regex = MCAICommands.sub(formatString, "\\{([^{}]+)\\}", match -> String.format("(?<%s>", match.substring(1, match.length() - 1)) + (match.equals("{user}") ? "[^:]" : ".") + "+)");
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(formattedString);
        if (matcher.find()) {
            return new Tuple<String>(matcher.group("user"), matcher.group("message"));
        }
        return new Tuple<String>("", "");
    }

    private static int getContext(class_2168 source2, String name, boolean broadcast) {
        for (MCAIConfig.CharacterTuple tuple : MCAIMod.CONFIG.ais) {
            if (!tuple.name.equalsIgnoreCase(name) && !Arrays.stream(tuple.aliases).anyMatch(alias -> alias.equalsIgnoreCase(name))) continue;
            if (tuple.historyId.isBlank()) {
                source2.method_9213((class_2561)class_2561.method_43469((String)"mcai.errors.no_history", (Object[])new Object[]{tuple.name}));
                continue;
            }
            Thread thread2 = new Thread(null, () -> {
                try {
                    int messageIndex;
                    List<JsonNode> chat = MCAIMod.CHARACTER_AI.chat.getHistory(tuple.historyId, false);
                    for (int i = 0; i < 6 && (messageIndex = 5 - i) < chat.size(); ++i) {
                        JsonNode msg = chat.get(messageIndex);
                        String text = msg.get("candidates").get(0).get("raw_content").asText();
                        Tuple<String> reversedFormat = MCAICommands.reverseFormat(MCAIMod.CONFIG.general.format, text);
                        text = MCAIMod.CONFIG.general.replyFormat.replace("{char}", msg.get("author").has("is_human") && msg.get("author").get("is_human").asBoolean(false) ? (CharSequence)reversedFormat.get(0) : tuple.name).replace("{message}", reversedFormat.get(1).isEmpty() ? text : (reversedFormat.get(1).charAt(0) == ' ' ? reversedFormat.get(1).substring(1) : (CharSequence)reversedFormat.get(1)));
                        if (broadcast) {
                            MCAIMod.sendGlobalMessage(text, source2.method_9211());
                            continue;
                        }
                        source2.method_45068((class_2561)class_2561.method_43470((String)text));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, "HTTP thread");
            thread2.start();
            return 1;
        }
        source2.method_9213((class_2561)class_2561.method_43469((String)"mcai.errors.ai_not_found", (Object[])new Object[]{name}));
        return 0;
    }

    private static int newChat(class_2168 source2, String name) {
        boolean foundAnAI = false;
        for (MCAIConfig.CharacterTuple tuple : MCAIMod.CONFIG.ais) {
            if (!tuple.name.equalsIgnoreCase(name) && !Arrays.stream(tuple.aliases).anyMatch(alias -> alias.equalsIgnoreCase(name))) continue;
            foundAnAI = true;
            if (tuple.disabled) continue;
            Thread thread2 = new Thread(null, () -> {
                try {
                    Map<String, JsonNode> chat = MCAIMod.CHARACTER_AI.chat.newChat(tuple.id, true, null).get();
                    tuple.historyId = chat.get("chat_id").asText();
                    MCAIConfig.save();
                    MCAIMod.setLastCommunicatedWith(tuple);
                    String text = MCAIMod.CONFIG.general.replyFormat.replace("{char}", chat.get("src_char").get("participant").get("name").asText()).replace("{message}", chat.get("messages").get(0).get("text").asText()).replace("\n\n", "\n");
                    MCAIMod.LOGGER.info(text);
                    MCAIMod.sendGlobalMessage(text, source2.method_9211());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }, "HTTP thread");
            thread2.start();
            return 1;
        }
        source2.method_9213((class_2561)class_2561.method_43469((String)(!foundAnAI ? "mcai.errors.ai_not_found" : "mcai.errors.no_suitable_ai_found"), (Object[])new Object[]{name}));
        return 0;
    }

    private static int toggleAI(class_2168 source2, String name, boolean disable) {
        boolean foundAnAI = false;
        for (MCAIConfig.CharacterTuple tuple : MCAIMod.CONFIG.ais) {
            if (!tuple.name.equalsIgnoreCase(name) && !Arrays.stream(tuple.aliases).anyMatch(alias -> alias.equalsIgnoreCase(name))) continue;
            foundAnAI = true;
            if (tuple.disabled != !disable) continue;
            tuple.disabled = disable;
            MCAIConfig.save();
            source2.method_9226(() -> class_2561.method_43469((String)String.format("mcai.messages.%sabled_ai", disable ? "dis" : "en"), (Object[])new Object[]{tuple.name}), true);
            return 1;
        }
        source2.method_9213((class_2561)class_2561.method_43469((String)(!foundAnAI ? "mcai.errors.ai_not_found" : "mcai.errors.no_suitable_ai_found"), (Object[])new Object[]{name}));
        return 0;
    }

    private static int authorize(class_2168 source2, String token) {
        MCAIMod.CONFIG.general.authorization = token;
        MCAIConfig.save();
        MCAIMod.CHARACTER_AI.updateAuthorization();
        source2.method_9226(() -> class_2561.method_43469((String)"mcai.messages.authorized", (Object[])new Object[]{token}), true);
        return 1;
    }

    private static int list(class_2168 source2) {
        StringBuilder string = new StringBuilder();
        MCAIMod.CONFIG.ais.forEach(tuple -> string.append(String.format("\n - %s %s", tuple.name, class_2561.method_43471((String)String.format("mcai.messages.%s", tuple.disabled ? "disabled" : "enabled")).getString())).append((String)(tuple.aliases.length > 0 ? " " + Arrays.toString(tuple.aliases) : "")));
        source2.method_9226(() -> class_2561.method_43469((String)"mcai.messages.ai_list", (Object[])new Object[]{string.toString()}), false);
        return 1;
    }
}

