/*
 * Decompiled with CFR 0.152.
 */
package com.alfred.ai;

import com.alfred.ai.EchoPayload;
import com.alfred.ai.JavaCAI;
import com.alfred.ai.MCAICommands;
import com.alfred.ai.MCAIConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.mojang.brigadier.CommandDispatcher;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCAIMod
implements ModInitializer {
    public static final String MOD_ID = "mcai";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MCAI");
    public static JavaCAI CHARACTER_AI;
    public static final class_2960 ON_SERVER_PACKET_ID;
    public static MCAIConfig CONFIG;
    public static Map<MCAIConfig.CharacterTuple, ZonedDateTime> lastTalkedTo;

    public void onInitialize() {
        CONFIG = (MCAIConfig)AutoConfig.register(MCAIConfig.class, GsonConfigSerializer::new).getConfig();
        CHARACTER_AI = new JavaCAI();
        Random random = new Random();
        PayloadTypeRegistry.playS2C().register(EchoPayload.ID, EchoPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(EchoPayload.ID, EchoPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(EchoPayload.ID, (server, ctx) -> ServerPlayNetworking.send((class_3222)ctx.player(), (class_8710)new EchoPayload()));
        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> {
            String text = message.method_44862();
            for (MCAIConfig.CharacterTuple tuple : MCAIMod.CONFIG.ais) {
                String[] arr;
                if (tuple.disabled) continue;
                ArrayList<String> list = new ArrayList<String>(Arrays.stream(tuple.aliases).toList());
                list.addFirst(tuple.name);
                for (String name : arr = (String[])list.toArray(String[]::new)) {
                    if (!(text.toLowerCase().contains(String.format("@%s", name.toLowerCase())) || tuple.randomResponseChance > random.nextFloat() && !MCAIMod.CONFIG.general.disableRandomResponses) && (MCAIMod.CONFIG.general.disableEveryonePing || !text.toLowerCase().contains("@everyone ") && !text.toLowerCase().contains("@ai "))) continue;
                    if (MCAIMod.CONFIG.general.authorization.isBlank()) {
                        sender.method_43496((class_2561)class_2561.method_43471((String)"mcai.errors.no_authorization_token").method_54663(0xFF1111));
                        return;
                    }
                    if (text.toLowerCase().startsWith(String.format("@%s", name.toLowerCase()))) {
                        text = text.substring(name.length() + 1);
                    }
                    MCAIMod.sendAIMessage(text, tuple, sender.method_5477().getString(), MCAIMod.CONFIG.general.format, MCAIMod.CONFIG.general.replyFormat, sender.method_5682());
                }
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MCAICommands.register((CommandDispatcher<class_2168>)dispatcher));
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            if (!MCAIMod.CONFIG.general.disableRandomTalking) {
                Double globalLastTalkedWith = null;
                for (MCAIConfig.CharacterTuple tuple : MCAIMod.CONFIG.ais) {
                    double lastTalkedWith = MCAIMod.getLastCommunicatedWith(ZonedDateTime.now(), tuple);
                    if (globalLastTalkedWith != null && !(lastTalkedWith < globalLastTalkedWith)) continue;
                    globalLastTalkedWith = lastTalkedWith;
                }
                for (MCAIConfig.CharacterTuple tuple : MCAIMod.CONFIG.ais) {
                    if (!(globalLastTalkedWith >= tuple.minimumSecondsBeforeRandomTalking) || !(tuple.randomTalkChance > random.nextFloat())) continue;
                    MCAIMod.sendAIMessage(" " + MCAIMod.CONFIG.general.randomTalkMessage.replace("{time}", MCAIMod.generalizeNumberToTime(tuple.talkIntervalSpecificity, globalLastTalkedWith)), tuple, MCAIMod.CONFIG.general.systemName, MCAIMod.CONFIG.general.format, MCAIMod.CONFIG.general.replyFormat, server);
                }
            }
        });
    }

    public static ZonedDateTime getLastCommunicatedWith(MCAIConfig.CharacterTuple tuple) {
        return lastTalkedTo.computeIfAbsent(tuple, key -> null);
    }

    public static double getLastCommunicatedWith(ZonedDateTime time, MCAIConfig.CharacterTuple tuple) {
        if (MCAIMod.getLastCommunicatedWith(tuple) == null) {
            return -1.0;
        }
        return (double)Duration.between(MCAIMod.getLastCommunicatedWith(tuple).toInstant(), time.toInstant()).toMillis() / 1000.0;
    }

    public static void setLastCommunicatedWith(MCAIConfig.CharacterTuple tuple) {
        MCAIMod.setLastCommunicatedWith(tuple, ZonedDateTime.now());
    }

    public static void setLastCommunicatedWith(MCAIConfig.CharacterTuple tuple, ZonedDateTime time) {
        lastTalkedTo.put(tuple, time);
    }

    public static String generalizeNumberToTime(double value, double number) {
        if (value >= 1.0) {
            return MCAIMod.formatDouble(number) + " seconds";
        }
        if (value <= 0.0) {
            return "some time";
        }
        double powerOf10 = Math.pow(10.0, (int)(-value * 10.0) + 1);
        return MCAIMod.formatDouble((double)Math.round(number / powerOf10) * powerOf10) + " seconds";
    }

    public static String formatDouble(double number) {
        return new DecimalFormat("#,###.######").format(number);
    }

    public static void sendPrivateMessage(String message, class_3222 player) {
        player.method_43496((class_2561)class_2561.method_43470((String)message));
    }

    public static void sendGlobalMessage(String text, MinecraftServer server) {
        if (server == null) {
            return;
        }
        MCAIMod.sendGlobalMessage(text, server.method_3760().method_14571());
    }

    public static void sendGlobalMessage(String text, List<class_3222> players) {
        players.forEach(player -> MCAIMod.sendPrivateMessage(text, player));
    }

    public static void sendAIMessage(String text, MCAIConfig.CharacterTuple tuple, String name, String format, String replyFormat, MinecraftServer server) {
        Thread thread2 = new Thread(null, () -> {
            try {
                if (tuple.historyId == null || tuple.historyId.isBlank()) {
                    Map<String, JsonNode> newChat = MCAIMod.CHARACTER_AI.chat.newChat(tuple.id, true, null).get();
                    tuple.historyId = newChat.get("chat").get("chat_id").asText();
                    MCAIConfig.save();
                }
                JsonNode reply = MCAIMod.CHARACTER_AI.chat.sendMessage(tuple.id, tuple.historyId, format.replace("{user}", name).replace("{message}", text), false).get();
                MCAIMod.setLastCommunicatedWith(tuple);
                String replyText = replyFormat.replace("{char}", tuple.name).replace("{message}", reply.get("candidates").get(0).get("raw_content").asText()).replace("\n\n", "\n");
                MCAIMod.sendGlobalMessage(replyText, server);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }, "HTTP thread");
        thread2.start();
    }

    static {
        ON_SERVER_PACKET_ID = class_2960.method_60655((String)MOD_ID, (String)"is_on_server_question_mark");
        lastTalkedTo = new HashMap<MCAIConfig.CharacterTuple, ZonedDateTime>();
    }
}

