/*
 * Decompiled with CFR 0.152.
 */
package com.alfred.ai;

import java.util.Arrays;

public class Tuple<T> {
    private final T[] elements;

    @SafeVarargs
    public Tuple(T ... elements) {
        this.elements = elements;
    }

    public T get(int index) {
        if (index < 0 || index >= this.elements.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds 0 - %d", this.elements.length));
        }
        return this.elements[index];
    }

    public void set(int index, T var) {
        if (index < 0 || index >= this.elements.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds 0 - %d", this.elements.length));
        }
        this.elements[index] = var;
    }

    public int size() {
        return this.elements.length;
    }

    public String toString() {
        return "Tuple" + Arrays.toString(this.elements);
    }
}

