/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.internal.Internal;
import okhttp3.internal._UtilCommonKt;
import okio.BufferedSink;
import okio.ByteString;
import okio.FileSystem;
import okio.HashingSink;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lokhttp3/RequestBody;", "", "<init>", "()V", "contentType", "Lokhttp3/MediaType;", "contentLength", "", "writeTo", "", "sink", "Lokio/BufferedSink;", "isDuplex", "", "isOneShot", "sha256", "Lokio/ByteString;", "Companion", "okhttp"})
public abstract class RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final RequestBody EMPTY = okhttp3.RequestBody$Companion.create$default(Companion, ByteString.EMPTY, null, 1, null);

    @Nullable
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(@NotNull BufferedSink var1) throws IOException;

    public boolean isDuplex() {
        return false;
    }

    public boolean isOneShot() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ByteString sha256() throws IOException {
        HashingSink hashingSink = HashingSink.Companion.sha256(Okio.blackhole());
        Closeable closeable = Okio.buffer(hashingSink);
        Throwable throwable = null;
        try {
            BufferedSink it = (BufferedSink)closeable;
            boolean bl = false;
            this.writeTo(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return hashingSink.hash();
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull String $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull ByteString $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull FileDescriptor $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull byte[] $this$create, @Nullable MediaType contentType, int offset, int byteCount) {
        return Companion.create($this$create, contentType, offset, byteCount);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull File $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull Path $this$create, @NotNull FileSystem fileSystem2, @Nullable MediaType contentType) {
        return Companion.create($this$create, fileSystem2, contentType);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull String content) {
        return Companion.create(contentType, content);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull ByteString content) {
        return Companion.create(contentType, content);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content, int offset, int byteCount) {
        return Companion.create(contentType, content, offset, byteCount);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'file' argument first to fix Java", replaceWith=@ReplaceWith(expression="file.asRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.asRequestBody"}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull File file) {
        return Companion.create(contentType, file);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull byte[] $this$create, @Nullable MediaType contentType, int offset) {
        return Companion.create($this$create, contentType, offset);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull byte[] $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull byte[] $this$create) {
        return Companion.create($this$create);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content, int offset) {
        return Companion.create(contentType, content, offset);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content) {
        return Companion.create(contentType, content);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0006\u001a\u00020\u0005*\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\b\nJ\u001d\u0010\u0006\u001a\u00020\u0005*\u00020\u000b2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\b\nJ\u001d\u0010\u0006\u001a\u00020\u0005*\u00020\f2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\b\nJ1\u0010\u0006\u001a\u00020\u0005*\u00020\r2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b\nJ\u001d\u0010\u0011\u001a\u00020\u0005*\u00020\u00122\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\b\nJ%\u0010\u0011\u001a\u00020\u0005*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\b\nJ\u001a\u0010\n\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\u001a\u0010\n\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u000bH\u0007J.\u0010\n\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007J\u001a\u0010\n\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0012H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokhttp3/RequestBody$Companion;", "", "<init>", "()V", "EMPTY", "Lokhttp3/RequestBody;", "toRequestBody", "", "contentType", "Lokhttp3/MediaType;", "create", "Lokio/ByteString;", "Ljava/io/FileDescriptor;", "", "offset", "", "byteCount", "asRequestBody", "Ljava/io/File;", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "content", "file", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull String $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter($this$toRequestBody, "<this>");
            Pair<Charset, MediaType> pair = Internal.chooseCharset(contentType);
            Charset charset = pair.component1();
            MediaType finalContentType = pair.component2();
            byte[] byArray = $this$toRequestBody.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            byte[] bytes = byArray;
            return this.create(bytes, finalContentType, 0, bytes.length);
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, String string, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(string, mediaType);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull ByteString $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter($this$toRequestBody, "<this>");
            return new RequestBody(contentType, $this$toRequestBody){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ ByteString $this_toRequestBody;
                {
                    this.$contentType = $contentType;
                    this.$this_toRequestBody = $receiver;
                }

                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$this_toRequestBody.size();
                }

                public void writeTo(BufferedSink sink2) {
                    Intrinsics.checkNotNullParameter(sink2, "sink");
                    sink2.write(this.$this_toRequestBody);
                }
            };
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, ByteString byteString, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(byteString, mediaType);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull FileDescriptor $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter($this$toRequestBody, "<this>");
            return new RequestBody(contentType, $this$toRequestBody){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ FileDescriptor $this_toRequestBody;
                {
                    this.$contentType = $contentType;
                    this.$this_toRequestBody = $receiver;
                }

                public MediaType contentType() {
                    return this.$contentType;
                }

                public boolean isOneShot() {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeTo(BufferedSink sink2) {
                    Intrinsics.checkNotNullParameter(sink2, "sink");
                    Closeable closeable = new FileInputStream(this.$this_toRequestBody);
                    Throwable throwable = null;
                    try {
                        FileInputStream it = (FileInputStream)closeable;
                        boolean bl = false;
                        long l = sink2.getBuffer().writeAll(Okio.source(it));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
            };
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, FileDescriptor fileDescriptor, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(fileDescriptor, mediaType);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull byte[] $this$toRequestBody, @Nullable MediaType contentType, int offset, int byteCount) {
            Intrinsics.checkNotNullParameter($this$toRequestBody, "<this>");
            _UtilCommonKt.checkOffsetAndCount($this$toRequestBody.length, offset, byteCount);
            return new RequestBody(contentType, byteCount, $this$toRequestBody, offset){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ int $byteCount;
                final /* synthetic */ byte[] $this_toRequestBody;
                final /* synthetic */ int $offset;
                {
                    this.$contentType = $contentType;
                    this.$byteCount = $byteCount;
                    this.$this_toRequestBody = $receiver;
                    this.$offset = $offset;
                }

                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$byteCount;
                }

                public void writeTo(BufferedSink sink2) {
                    Intrinsics.checkNotNullParameter(sink2, "sink");
                    sink2.write(this.$this_toRequestBody, this.$offset, this.$byteCount);
                }
            };
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, byte[] byArray, MediaType mediaType, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                mediaType = null;
            }
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.create(byArray, mediaType, n, n2);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull File $this$asRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter($this$asRequestBody, "<this>");
            return new RequestBody(contentType, $this$asRequestBody){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ File $this_asRequestBody;
                {
                    this.$contentType = $contentType;
                    this.$this_asRequestBody = $receiver;
                }

                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$this_asRequestBody.length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeTo(BufferedSink sink2) {
                    Intrinsics.checkNotNullParameter(sink2, "sink");
                    Closeable closeable = Okio.source(this.$this_asRequestBody);
                    Throwable throwable = null;
                    try {
                        Source source2 = (Source)closeable;
                        boolean bl = false;
                        long l = sink2.writeAll(source2);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
            };
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, File file, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(file, mediaType);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull Path $this$asRequestBody, @NotNull FileSystem fileSystem2, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter($this$asRequestBody, "<this>");
            Intrinsics.checkNotNullParameter(fileSystem2, "fileSystem");
            return new RequestBody(contentType, fileSystem2, $this$asRequestBody){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ FileSystem $fileSystem;
                final /* synthetic */ Path $this_asRequestBody;
                {
                    this.$contentType = $contentType;
                    this.$fileSystem = $fileSystem;
                    this.$this_asRequestBody = $receiver;
                }

                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    Long l = this.$fileSystem.metadata(this.$this_asRequestBody).getSize();
                    return l != null ? l : -1L;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeTo(BufferedSink sink2) {
                    Intrinsics.checkNotNullParameter(sink2, "sink");
                    Closeable closeable = this.$fileSystem.source(this.$this_asRequestBody);
                    Throwable throwable = null;
                    try {
                        Source source2 = (Source)closeable;
                        boolean bl = false;
                        long l = sink2.writeAll(source2);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
            };
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, Path path, FileSystem fileSystem2, MediaType mediaType, int n, Object object) {
            if ((n & 2) != 0) {
                mediaType = null;
            }
            return companion.create(path, fileSystem2, mediaType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull String content) {
            Intrinsics.checkNotNullParameter(content, "content");
            return this.create(content, contentType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull ByteString content) {
            Intrinsics.checkNotNullParameter(content, "content");
            return this.create(content, contentType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content, int offset, int byteCount) {
            Intrinsics.checkNotNullParameter(content, "content");
            return this.create(content, contentType, offset, byteCount);
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, MediaType mediaType, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = byArray.length;
            }
            return companion.create(mediaType, byArray, n, n2);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'file' argument first to fix Java", replaceWith=@ReplaceWith(expression="file.asRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.asRequestBody"}), level=DeprecationLevel.WARNING)
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull File file) {
            Intrinsics.checkNotNullParameter(file, "file");
            return this.create(file, contentType);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull byte[] $this$toRequestBody, @Nullable MediaType contentType, int offset) {
            Intrinsics.checkNotNullParameter($this$toRequestBody, "<this>");
            return okhttp3.RequestBody$Companion.create$default(this, $this$toRequestBody, contentType, offset, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull byte[] $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter($this$toRequestBody, "<this>");
            return okhttp3.RequestBody$Companion.create$default(this, $this$toRequestBody, contentType, 0, 0, 6, null);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull byte[] $this$toRequestBody) {
            Intrinsics.checkNotNullParameter($this$toRequestBody, "<this>");
            return okhttp3.RequestBody$Companion.create$default(this, $this$toRequestBody, null, 0, 0, 7, null);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content, int offset) {
            Intrinsics.checkNotNullParameter(content, "content");
            return okhttp3.RequestBody$Companion.create$default(this, contentType, content, offset, 0, 8, null);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content) {
            Intrinsics.checkNotNullParameter(content, "content");
            return okhttp3.RequestBody$Companion.create$default(this, contentType, content, 0, 0, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

