/*
 * Decompiled with CFR 0.152.
 */
package yiv.yivspresets.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import yiv.yivspresets.preset.Preset;
import yiv.yivspresets.preset.PresetProfiles;

@Environment(value=EnvType.CLIENT)
public class UserConfig {
    public List<Preset> presets = new ArrayList<Preset>();
    public String defaultPresetId;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static UserConfig loadOrCreate() {
        Path p = UserConfig.configPath();
        if (Files.exists(p, new LinkOption[0])) {
            try {
                String json = Files.readString(p);
                UserConfig cfg = (UserConfig)GSON.fromJson(json, UserConfig.class);
                if (cfg == null) {
                    cfg = new UserConfig();
                }
                cfg.normalize();
                cfg.save();
                return cfg;
            }
            catch (IOException json) {
                // empty catch block
            }
        }
        UserConfig cfg = new UserConfig();
        cfg.ensureDefaults();
        cfg.save();
        return cfg;
    }

    public void ensureDefaults() {
        if (this.presets.isEmpty()) {
            this.presets.add(new Preset(UserConfig.genId(), "Build", PresetProfiles.BUILD));
            this.presets.add(new Preset(UserConfig.genId(), "Explore", PresetProfiles.EXPLORE));
            this.presets.add(new Preset(UserConfig.genId(), "Combat", PresetProfiles.COMBAT));
            this.defaultPresetId = this.presets.get((int)1).id;
        }
        this.normalize();
    }

    public void normalize() {
        for (int i = 0; i < this.presets.size(); ++i) {
            PresetProfiles.Profile np;
            Preset pr = this.presets.get(i);
            if (pr == null || pr.profile == null) continue;
            PresetProfiles.Profile o = pr.profile;
            int render = UserConfig.clamp(o.renderDistance, 2, 32);
            int sim = o.simulationDistance > 0 ? o.simulationDistance : render;
            sim = UserConfig.clamp(sim, 5, 32);
            pr.profile = np = new PresetProfiles.Profile(render, sim, o.graphics, o.particles, o.clouds, o.smoothLighting, o.vSync, o.entityShadows, UserConfig.clamp(o.entityDistanceScaling, 0.5f, 5.0f), UserConfig.clamp(o.mipmapLevels, 0, 4), UserConfig.clamp(o.biomeBlendRadius, 0, 7), o.viewBobbing, UserConfig.clamp(o.distortionEffectsScale, 0.0f, 1.0f), UserConfig.clamp(o.maxFps, 5, 260));
        }
    }

    private static int clamp(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }

    public Preset getById(String id) {
        for (Preset p : this.presets) {
            if (!p.id.equals(id)) continue;
            return p;
        }
        return null;
    }

    public boolean removePreset(String id) {
        return this.presets.removeIf(p -> p.id.equals(id));
    }

    public void addPreset(String name, PresetProfiles.Profile profile) {
        this.presets.add(new Preset(UserConfig.genId(), name, profile));
        if (this.defaultPresetId == null) {
            this.defaultPresetId = this.presets.get((int)0).id;
        }
    }

    public void save() {
        try {
            Files.createDirectories(UserConfig.configPath().getParent(), new FileAttribute[0]);
            Files.writeString(UserConfig.configPath(), (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Path configPath() {
        Path dir = class_310.method_1551().field_1697.toPath().resolve("config");
        return dir.resolve("yivs-presets.json");
    }

    private static String genId() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

