/*
 * Decompiled with CFR 0.152.
 */
package yiv.yivspresets.config;

import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import yiv.yivspresets.config.UserConfig;
import yiv.yivspresets.preset.Preset;
import yiv.yivspresets.preset.PresetProfiles;

@Environment(value=EnvType.CLIENT)
public class PresetEditorScreen
extends class_437 {
    private final class_437 parent;
    private final String presetId;
    private UserConfig cfg;
    private class_342 nameField;
    private int renderDistance;
    private int simulationDistance;
    private PresetProfiles.Graphics graphics;
    private PresetProfiles.Particles particles;
    private PresetProfiles.Clouds clouds;
    private boolean smoothLighting;
    private boolean vSync;
    private boolean entityShadows;
    private float entityDistanceScaling;
    private int mipmapLevels;
    private int biomeBlendRadius;
    private boolean viewBobbing;
    private float distortionEffectsScale;
    private int maxFps;

    public PresetEditorScreen(class_437 parent, String presetId) {
        super((class_2561)class_2561.method_43470((String)"Edit Preset"));
        this.parent = parent;
        this.presetId = presetId;
    }

    protected void method_25426() {
        this.cfg = UserConfig.loadOrCreate();
        Preset def = this.cfg.getById(this.presetId);
        if (def == null || def.profile == null) {
            class_310.method_1551().method_1507(this.parent);
            return;
        }
        PresetProfiles.Profile p = def.profile;
        this.renderDistance = p.renderDistance;
        this.simulationDistance = p.simulationDistance;
        this.graphics = p.graphics;
        this.particles = p.particles;
        this.clouds = p.clouds;
        this.smoothLighting = p.smoothLighting;
        this.vSync = p.vSync;
        this.entityShadows = p.entityShadows;
        this.entityDistanceScaling = p.entityDistanceScaling;
        this.mipmapLevels = p.mipmapLevels;
        this.biomeBlendRadius = p.biomeBlendRadius;
        this.viewBobbing = p.viewBobbing;
        this.distortionEffectsScale = p.distortionEffectsScale;
        this.maxFps = p.maxFps;
        int panelW = 360;
        int left = Math.round((float)this.field_22789 / 2.0f - (float)panelW / 2.0f);
        int y = this.field_22790 / 6 + 6;
        this.method_37063((class_364)new class_7842(left, y, panelW, 20, (class_2561)class_2561.method_43470((String)("Editing: " + def.name + " (" + def.id + ")")), this.field_22793));
        this.nameField = new class_342(this.field_22793, left, y += 22, panelW, 20, (class_2561)class_2561.method_43470((String)"Name"));
        this.nameField.method_1852(def.name);
        this.method_25429((class_364)this.nameField);
        this.method_37063((class_364)this.nameField);
        IntSlider rd = new IntSlider(left, y += 26, panelW, 20, "Render Distance", this.renderDistance, 2, 32, 1, v -> {
            this.renderDistance = v;
        });
        this.method_37063((class_364)rd);
        IntSlider sd = new IntSlider(left, y += 24, panelW, 20, "Simulation Distance", this.simulationDistance, 5, 32, 1, v -> {
            this.simulationDistance = v;
        });
        this.method_37063((class_364)sd);
        this.method_37063((class_364)class_5676.method_32606(g -> class_2561.method_43470((String)g.name())).method_32624((Object[])PresetProfiles.Graphics.values()).method_32619((Object)this.graphics).method_32617(left, y += 24, panelW, 20, (class_2561)class_2561.method_43470((String)"Graphics"), (btn, val) -> {
            this.graphics = val;
        }));
        this.method_37063((class_364)class_5676.method_32606(p0 -> class_2561.method_43470((String)p0.name())).method_32624((Object[])PresetProfiles.Particles.values()).method_32619((Object)this.particles).method_32617(left, y += 24, panelW, 20, (class_2561)class_2561.method_43470((String)"Particles"), (btn, val) -> {
            this.particles = val;
        }));
        this.method_37063((class_364)class_5676.method_32606(c -> class_2561.method_43470((String)c.name())).method_32624((Object[])PresetProfiles.Clouds.values()).method_32619((Object)this.clouds).method_32617(left, y += 24, panelW, 20, (class_2561)class_2561.method_43470((String)"Clouds"), (btn, val) -> {
            this.clouds = val;
        }));
        int gap2 = 8;
        int half = (panelW - gap2) / 2;
        this.method_37063((class_364)class_5676.method_32613((boolean)this.smoothLighting).method_32617(left, y += 24, half, 20, (class_2561)class_2561.method_43470((String)"Smooth Lighting"), (btn, val) -> {
            this.smoothLighting = val;
        }));
        this.method_37063((class_364)class_5676.method_32613((boolean)this.entityShadows).method_32617(left + half + gap2, y, half, 20, (class_2561)class_2561.method_43470((String)"Entity Shadows"), (btn, val) -> {
            this.entityShadows = val;
        }));
        this.method_37063((class_364)class_5676.method_32613((boolean)this.vSync).method_32617(left, y += 24, panelW, 20, (class_2561)class_2561.method_43470((String)"VSync"), (btn, val) -> {
            this.vSync = val;
        }));
        FloatSlider ed = new FloatSlider(left, y += 24, panelW, 20, "Entity Distance", this.entityDistanceScaling, 0.5f, 5.0f, 0.05f, v -> {
            this.entityDistanceScaling = v.floatValue();
        }, v -> String.format("%.2f", v));
        this.method_37063((class_364)ed);
        IntSlider mm = new IntSlider(left, y += 24, half, 20, "Mipmap Levels", this.mipmapLevels, 0, 4, 1, v -> {
            this.mipmapLevels = v;
        });
        this.method_37063((class_364)mm);
        IntSlider bb = new IntSlider(left + half + gap2, y, half, 20, "Biome Blend", this.biomeBlendRadius, 0, 7, 1, v -> {
            this.biomeBlendRadius = v;
        });
        this.method_37063((class_364)bb);
        this.method_37063((class_364)class_5676.method_32613((boolean)this.viewBobbing).method_32617(left, y += 24, panelW, 20, (class_2561)class_2561.method_43470((String)"View Bobbing"), (btn, val) -> {
            this.viewBobbing = val;
        }));
        FloatSlider dist = new FloatSlider(left, y += 24, panelW, 20, "Distortion", this.distortionEffectsScale, 0.0f, 1.0f, 0.05f, v -> {
            this.distortionEffectsScale = v.floatValue();
        }, v -> String.format("%.2f", v));
        this.method_37063((class_364)dist);
        IntSlider fps = new IntSlider(this, left, y += 24, panelW, 20, "Max FPS", this.maxFps, 5, 260, 5, v -> {
            this.maxFps = v;
        }){

            @Override
            protected class_2561 composeMessage() {
                String val = this.valueInt >= 260 ? "Unlimited" : String.valueOf(this.valueInt);
                return class_2561.method_43470((String)(this.label + ": " + val));
            }
        };
        this.method_37063((class_364)fps);
        int btnW = 100;
        int gap = 12;
        int rowW = btnW + gap + btnW;
        int groupLeft = Math.round((float)this.field_22789 / 2.0f - (float)rowW / 2.0f);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            this.applyAndSave();
            class_310.method_1551().method_1507(this.parent);
        }).method_46434(groupLeft, y += 28, btnW, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> class_310.method_1551().method_1507(this.parent)).method_46434(groupLeft + btnW + gap, y, btnW, 20).method_46431());
    }

    private void applyAndSave() {
        Preset d = this.cfg.getById(this.presetId);
        if (d == null) {
            return;
        }
        d.name = this.nameField.method_1882() != null && !this.nameField.method_1882().isBlank() ? this.nameField.method_1882().trim() : d.name;
        d.profile = new PresetProfiles.Profile(this.renderDistance, this.simulationDistance, this.graphics, this.particles, this.clouds, this.smoothLighting, this.vSync, this.entityShadows, this.entityDistanceScaling, this.mipmapLevels, this.biomeBlendRadius, this.viewBobbing, this.distortionEffectsScale, this.maxFps);
        this.cfg.save();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_52752(ctx);
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
    }

    @Environment(value=EnvType.CLIENT)
    private static class IntSlider
    extends BaseSlider {
        private final Consumer<Integer> onChange;

        public IntSlider(int x, int y, int w, int h, String label, int initial, int min, int max, int step, Consumer<Integer> onChange) {
            super(x, y, w, h, label, initial, min, max, step);
            this.onChange = onChange;
        }

        protected void method_25344() {
            double range = this.max - this.min;
            int stepped = (int)Math.round(this.field_22753 * range / (double)this.step) * this.step + this.min;
            this.setInt(stepped);
            this.onChange.accept(this.valueInt);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class FloatSlider
    extends class_357 {
        private final float min;
        private final float max;
        private final float step;
        private final String label;
        private float valueF;
        private final Consumer<Float> onChange;
        private final Function<Float, String> formatter;

        public FloatSlider(int x, int y, int w, int h, String label, float initial, float min, float max, float step, Consumer<Float> onChange, Function<Float, String> formatter) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), 0.0);
            this.label = label;
            this.min = min;
            this.max = max;
            this.step = Math.max(1.0E-4f, step);
            this.onChange = onChange;
            this.formatter = formatter;
            this.setFloat(initial);
        }

        private void setFloat(float v) {
            this.valueF = Math.max(this.min, Math.min(this.max, v));
            double range = this.max - this.min;
            this.field_22753 = range == 0.0 ? 0.0 : (double)(this.valueF - this.min) / range;
            this.method_25346();
        }

        protected void method_25346() {
            String s = this.formatter != null ? this.formatter.apply(Float.valueOf(this.valueF)) : String.format("%.2f", Float.valueOf(this.valueF));
            this.method_25355((class_2561)class_2561.method_43470((String)(this.label + ": " + s)));
        }

        protected void method_25344() {
            double range = this.max - this.min;
            float stepped = (float)Math.round((this.field_22753 * range + (double)this.min) / (double)this.step) * this.step;
            this.setFloat(stepped);
            this.onChange.accept(Float.valueOf(this.valueF));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static abstract class BaseSlider
    extends class_357 {
        protected final int min;
        protected final int max;
        protected final int step;
        protected final String label;
        protected int valueInt;

        protected BaseSlider(int x, int y, int w, int h, String label, int initial, int min, int max, int step) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), 0.0);
            this.label = label;
            this.min = min;
            this.max = max;
            this.step = Math.max(1, step);
            this.valueInt = Math.max(min, Math.min(max, initial));
            double range = max - min;
            this.field_22753 = range == 0.0 ? 0.0 : (double)(this.valueInt - min) / range;
            this.method_25355((class_2561)class_2561.method_43470((String)(label + ": " + this.valueInt)));
        }

        protected void setInt(int v) {
            this.valueInt = Math.max(this.min, Math.min(this.max, v));
            double range = this.max - this.min;
            this.field_22753 = range == 0.0 ? 0.0 : (double)(this.valueInt - this.min) / range;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355(this.composeMessage());
        }

        protected class_2561 composeMessage() {
            return class_2561.method_43470((String)(this.label + ": " + this.valueInt));
        }
    }
}

